/*! For license information please see admin.js.LICENSE.txt */
(()=>{var e={113:(e,t,n)=>{"use strict";n.d(t,{G:()=>i,a:()=>o});const o=(e,t={},n=[])=>{let o=document.createElement(e);return Object.keys(t).length&&Object.entries(t).forEach((([e,t])=>{o.setAttribute(e,t)})),n.length&&o.append(...n),o},i=()=>"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(e=>{const t=16*Math.random()|0;return("x"===e?t:3&t|8).toString(16)}))},271:()=>{!function(e,t){var n={version:302};if("wpColorPickerAlpha"in window&&"version"in window.wpColorPickerAlpha){var o=parseInt(window.wpColorPickerAlpha.version,10);if(!isNaN(o)&&o>=n.version)return}if(!Color.fn.hasOwnProperty("to_s")){Color.fn.to_s=function(e){"hex"===(e=e||"hex")&&this._alpha<1&&(e="rgba");var t="";return"hex"===e?t=this.toString():this.error||(t=this.toCSS(e).replace(/\(\s+/,"(").replace(/\s+\)/,")")),t},window.wpColorPickerAlpha=n;var i="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAIAAAHnlligAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAHJJREFUeNpi+P///4EDBxiAGMgCCCAGFB5AADGCRBgYDh48CCRZIJS9vT2QBAggFBkmBiSAogxFBiCAoHogAKIKAlBUYTELAiAmEtABEECk20G6BOmuIl0CIMBQ/IEMkO0myiSSraaaBhZcbkUOs0HuBwDplz5uFJ3Z4gAAAABJRU5ErkJggg==";e.widget("a8c.iris",e.a8c.iris,{alphaOptions:{alphaEnabled:!1},_getColor:function(e){return e===t&&(e=this._color),this.alphaOptions.alphaEnabled?(e=e.to_s(this.alphaOptions.alphaColorType),this.alphaOptions.alphaColorWithSpace||(e=e.replace(/\s+/g,"")),e):e.toString()},_create:function(){try{this.alphaOptions=this.element.wpColorPicker("instance").alphaOptions}catch(e){}e.extend({},this.alphaOptions,{alphaEnabled:!1,alphaCustomWidth:130,alphaReset:!1,alphaColorType:"hex",alphaColorWithSpace:!1}),this._super()},_addInputListeners:function(e){var t=this,n=function(n){var o=e.val(),i=new Color(o),r=(o=o.replace(/^(#|(rgb|hsl)a?)/,""),t.alphaOptions.alphaColorType);e.removeClass("iris-error"),i.error?""!==o&&e.addClass("iris-error"):"hex"===r&&"keyup"===n.type&&o.match(/^[0-9a-fA-F]{3}$/)||i.toIEOctoHex()!==t._color.toIEOctoHex()&&t._setOption("color",t._getColor(i))};e.on("change",n).on("keyup",t._debounce(n,100)),t.options.hide&&e.one("focus",(function(){t.show()}))},_initControls:function(){if(this._super(),this.alphaOptions.alphaEnabled){var t=this,n=t.controls.strip.clone(!1,!1),o=n.find(".iris-slider-offset"),i={stripAlpha:n,stripAlphaSlider:o};n.addClass("iris-strip-alpha"),o.addClass("iris-slider-offset-alpha"),n.appendTo(t.picker.find(".iris-picker-inner")),e.each(i,(function(e,n){t.controls[e]=n})),t.controls.stripAlphaSlider.slider({orientation:"vertical",min:0,max:100,step:1,value:parseInt(100*t._color._alpha),slide:function(e,n){t.active="strip",t._color._alpha=parseFloat(n.value/100),t._change.apply(t,arguments)}})}},_dimensions:function(e){if(this._super(e),this.alphaOptions.alphaEnabled){var t,n,o,i,r,s=this,a=s.options,l=s.controls.square,c=s.picker.find(".iris-strip");for(t=Math.round(s.picker.outerWidth(!0)-(a.border?22:0)),n=Math.round(l.outerWidth()),o=Math.round((t-n)/2),i=Math.round(o/2),r=Math.round(n+2*o+2*i);r>t;)o=Math.round(o-2),i=Math.round(i-1),r=Math.round(n+2*o+2*i);l.css("margin","0"),c.width(o).css("margin-left",i+"px")}},_change:function(){var t=this,n=t.active;if(t._super(),t.alphaOptions.alphaEnabled){var o=t.controls,r=parseInt(100*t._color._alpha),s=t._color.toRgb(),a=["rgb("+s.r+","+s.g+","+s.b+") 0%","rgba("+s.r+","+s.g+","+s.b+", 0) 100%"];t.picker.closest(".wp-picker-container").find(".wp-color-result");t.options.color=t._getColor(),o.stripAlpha.css({background:"linear-gradient(to bottom, "+a.join(", ")+"), url("+i+")"}),n&&o.stripAlphaSlider.slider("value",r),t._color.error||t.element.removeClass("iris-error").val(t.options.color),t.picker.find(".iris-palette-container").on("click.palette",".iris-palette",(function(){var n=e(this).data("color");t.alphaOptions.alphaReset&&(t._color._alpha=1,n=t._getColor()),t._setOption("color",n)}))}},_paintDimension:function(e,t){var n=this,o=!1;n.alphaOptions.alphaEnabled&&"strip"===t&&(o=n._color,n._color=new Color(o.toString()),n.hue=n._color.h()),n._super(e,t),o&&(n._color=o)},_setOption:function(e,t){var n=this;if("color"!==e||!n.alphaOptions.alphaEnabled)return n._super(e,t);t=""+t,newColor=new Color(t).setHSpace(n.options.mode),newColor.error||n._getColor(newColor)===n._getColor()||(n._color=newColor,n.options.color=n._getColor(),n.active="external",n._change())},color:function(e){return!0===e?this._color.clone():e===t?this._getColor():void this.option("color",e)}}),e.widget("wp.wpColorPicker",e.wp.wpColorPicker,{alphaOptions:{alphaEnabled:!1},_getAlphaOptions:function(){var t=this.element,n=t.data("type")||this.options.type,o=t.data("defaultColor")||t.val(),i={alphaEnabled:t.data("alphaEnabled")||!1,alphaCustomWidth:130,alphaReset:!1,alphaColorType:"rgb",alphaColorWithSpace:!1};return i.alphaEnabled&&(i.alphaEnabled=t.is("input")&&"full"===n),i.alphaEnabled?(i.alphaColorWithSpace=o&&o.match(/\s/),e.each(i,(function(e,n){var r=t.data(e)||n;switch(e){case"alphaCustomWidth":r=r?parseInt(r,10):0,r=isNaN(r)?n:r;break;case"alphaColorType":r.match(/^(hex|(rgb|hsl)a?)$/)||(r=o&&o.match(/^#/)?"hex":o&&o.match(/^hsla?/)?"hsl":n);break;default:r=!!r}i[e]=r})),i):i},_create:function(){e.support.iris&&(this.alphaOptions=this._getAlphaOptions(),this._super())},_addListeners:function(){if(!this.alphaOptions.alphaEnabled)return this._super();var t=this,n=t.element,o=t.toggler.is("a");this.alphaOptions.defaultWidth=n.width(),this.alphaOptions.alphaCustomWidth&&n.width(parseInt(this.alphaOptions.defaultWidth+this.alphaOptions.alphaCustomWidth,10)),t.toggler.css({position:"relative","background-image":"url("+i+")"}),o?t.toggler.html('<span class="color-alpha" />'):t.toggler.append('<span class="color-alpha" />'),t.colorAlpha=t.toggler.find("span.color-alpha").css({width:"30px",height:"100%",position:"absolute",top:0,"background-color":n.val()}),"ltr"===t.colorAlpha.css("direction")?t.colorAlpha.css({"border-bottom-left-radius":"2px","border-top-left-radius":"2px",left:0}):t.colorAlpha.css({"border-bottom-right-radius":"2px","border-top-right-radius":"2px",right:0}),n.iris({change:function(e,n){t.colorAlpha.css({"background-color":n.color.to_s(t.alphaOptions.alphaColorType)}),"function"==typeof t.options.change&&t.options.change.call(this,e,n)}}),t.wrap.on("click.wpcolorpicker",(function(e){e.stopPropagation()})),t.toggler.on("click",(function(){t.toggler.hasClass("wp-picker-open")?t.close():t.open()})),n.on("change",(function(i){var r=e(this).val();(n.hasClass("iris-error")||""===r||r.match(/^(#|(rgb|hsl)a?)$/))&&(o&&t.toggler.removeAttr("style"),t.colorAlpha.css("background-color",""),"function"==typeof t.options.clear&&t.options.clear.call(this,i))})),t.button.on("click",(function(i){e(this).hasClass("wp-picker-default")?n.val(t.options.defaultColor).change():e(this).hasClass("wp-picker-clear")&&(n.val(""),o&&t.toggler.removeAttr("style"),t.colorAlpha.css("background-color",""),"function"==typeof t.options.clear&&t.options.clear.call(this,i),n.trigger("change"))}))}})}}(jQuery)},294:(e,t,n)=>{"use strict";n(926);var o=n(113);class i extends HTMLElement{el(e,t={},n=[]){return(0,o.a)(e,t,n)}triggerCustomEvent(e){this.dispatchEvent(new CustomEvent(e))}}const r=i;class s extends r{constructor(){super(),this.attachShadow({mode:"open"});const e=document.createElement("style");e.textContent=s.getStyle(),this.shadowRoot.append(e,...this.getWrapperTemplate())}attributeChangedCallback(e,t,n){const o=this.shadowRoot.querySelector(".shapla-modal");if("open"===e&&this.hasAttribute("open")?o.classList.add("is-active"):o.classList.remove("is-active"),"type"===e){const e=this.shadowRoot.querySelector(".shapla-modal-content");"box"===n&&(e.classList.contains("shapla-modal-box")||e.classList.add("shapla-modal-box"))}}static get observedAttributes(){return["open","type"]}connectedCallback(){const e=this.getAttribute("type");if("card"===e){this.renderCardTemplate();const e=this.shadowRoot.querySelector(".shapla-modal-card__footer");e.querySelector("slot").assignedNodes().length<1&&e.classList.add("no-content")}"confirm"===e&&this.updateConfirmDom();const t=this.shadowRoot.querySelector(".shapla-modal-close.is-fixed"),n=this.shadowRoot.querySelector(".shapla-modal-content");"confirm"===e?(t.remove(),n.classList.add("shapla-modal-confirm"),n.innerHTML="",n.append(...this.getConfirmTemplate())):"box"===e&&n.classList.add("shapla-modal-box");const o=this.shadowRoot.querySelector(".shapla-modal-background"),i=this.getAttribute("backdrop-theme");-1!==["dark","light"].indexOf(i)&&o.classList.add(`is-${i}`),this.updateContentSize(),this.closeOnEscape(),this.closeOnBackdropClick(),this.closeOnCrossClick()}renderCardTemplate(){const e=this.shadowRoot.querySelector(".shapla-modal-close.is-fixed"),t=this.shadowRoot.querySelector(".shapla-modal-content");e.remove(),t.classList.add("shapla-modal-card"),t.innerHTML="",t.append(...this.getCartTemplate());const n=this.getAttribute("heading");n&&(this.shadowRoot.querySelector(".shapla-modal-card__title").innerHTML=n)}updateContentSize(){const e=this.getAttribute("content-size");-1!==["small","medium","large","full","custom"].indexOf(e)&&this.shadowRoot.querySelector(".shapla-modal-content").classList.add(`is-${e}`)}updateConfirmDom(){const e=this.getAttribute("icon")??"primary",t=this.getAttribute("heading"),n=this.getAttribute("message")??"Are you sure?",o=this.getAttribute("confirm-button")??"Ok",i=this.getAttribute("cancel-button")??"Cancel",r=this.shadowRoot.querySelector(".button--confirm"),s=this.shadowRoot.querySelector(".button--cancel");o&&(r.innerHTML=o),i&&(s.innerHTML=i);const a=this.shadowRoot.querySelector(".shapla-modal-confirm");-1!==["primary","success","error"].indexOf(e)&&a.querySelector(".shapla-modal-confirm__icon")?.classList.add(`is-${e}`),this.hasAttribute("content-size")||(this.setAttribute("content-size","small"),this.updateContentSize()),this.hasAttribute("disabled-backdrop-click")||this.setAttribute("disabled-backdrop-click",""),t.length&&(a.querySelector(".shapla-modal-confirm__title").innerHTML=t),n.length&&(a.querySelector(".shapla-modal-confirm__message").innerHTML=n),this.closeOnCrossClick()}closeOnCrossClick(){(this.shadowRoot.querySelectorAll(".shapla-modal-close, .button--cancel")||[]).forEach((e=>{e.addEventListener("click",(()=>this.triggerCloseEvent()))}))}closeOnBackdropClick(){const e=this.shadowRoot.querySelector(".shapla-modal-background");this.hasAttribute("disabled-backdrop-click")||"confirm"!==this.getAttribute("type")&&e.addEventListener("click",(()=>this.triggerCloseEvent()))}closeOnEscape(){document.addEventListener("keydown",(e=>{27===(e||window.event).keyCode&&this.hasAttribute("open")&&this.triggerCloseEvent()}))}triggerCloseEvent(){this.triggerCustomEvent("close")}getWrapperTemplate(){return[this.el("div",{class:"shapla-modal"},[this.el("div",{class:"shapla-modal-background"}),this.el("shapla-cross",{class:"shapla-modal-close is-fixed",size:"large"}),this.el("div",{class:"shapla-modal-content"},[this.el("slot")])])]}getCartTemplate(){return[this.el("header",{class:"shapla-modal-card__header"},[this.el("div",{class:"shapla-modal-card__title"},[this.el("slot",{name:"heading"})]),this.el("shapla-cross",{class:"shapla-modal-close",size:"medium"})]),this.el("section",{class:"shapla-modal-card__body"},[this.el("slot")]),this.el("footer",{class:"shapla-modal-card__footer is-pulled-right"},[this.el("slot",{name:"footer"})])]}getConfirmTemplate(){return[this.el("div",{class:"shapla-modal-confirm__content"},[this.el("div",{class:"shapla-modal-confirm__icon"},[this.el("div",{class:"shapla-modal-confirm__icon-content"},["!"])]),this.el("h3",{class:"shapla-modal-confirm__title"}),this.el("div",{class:"shapla-modal-confirm__message"})]),this.el("div",{class:"shapla-modal-confirm__actions"},[this.el("slot",{name:"actions"},[this.el("button",{class:"shapla-button button--cancel"}),this.el("button",{class:"shapla-button is-primary button--confirm"})])])]}static getStyle(){return".shapla-modal,.shapla-modal-background{bottom:0;left:0;position:absolute;right:0;top:0}\n    .shapla-modal{align-items:center;display:none;flex-direction:column;justify-content:center;overflow:hidden;\n    position:fixed;z-index:var(--modal-z-index,100000)}\n    .shapla-modal.is-active{display:flex}\n    .shapla-modal-background{background-color:var(--modal-backdrop-color,rgba(0,0,0,.5))}\n    .shapla-modal-background.is-light{--modal-backdrop-color:var(--modal-backdrop-color-light,hsla(0,0%,100%,.5))}\n    .shapla-modal .shapla-delete-icon.is-fixed,.shapla-modal .shapla-modal-close.is-fixed{\n    position:fixed;right:var(--modal-close-right,1.25rem);top:var(--modal-close-top,1.25rem)}\n    .shapla-modal-content{margin:0 var(--modal-content-margin,20px);\n    max-height:calc(100vh - var(--modal-content-spacing, 160px));overflow:auto;position:relative;\n    width:var(--modal-content-width,calc(100% - var(--modal-content-margin, 20px)*2))}\n    .shapla-modal-content.is-small{--modal-content-width:var(--modal-content-width-small,320px)}\n    .shapla-modal-content.is-full{height:calc(100vh - var(--modal-content-margin, 20px)*2);\n    width:calc(100vw - var(--modal-content-margin, 20px)*2)}\n    @media print,screen and (min-width:768px){\n    .shapla-modal-content{--modal-content-spacing:40px;margin:0 auto}\n    .shapla-modal-content:not(.is-small):not(.is-full):not(.is-large){\n    --modal-content-width:var(--modal-content-width-medium,640px)}}\n    @media screen and (min-width:1024px){\n    .shapla-modal-content.is-large{--modal-content-width:var(--modal-content-width-large,960px)}}\n    .shapla-modal-card{display:flex;flex-direction:column;max-height:calc(100vh - 40px);overflow:hidden}\n    .shapla-modal-card__footer,.shapla-modal-card__header{align-items:center;background-color:#fff;display:flex;\n    flex-shrink:0;justify-content:flex-start;padding:1rem;position:relative}\n    .shapla-modal-card__footer>*+*,.shapla-modal-card__header>*+*{margin-left:.5rem}\n    .shapla-modal-card__header{border-bottom:1px solid rgba(0,0,0,.12);border-top-left-radius:4px;\n    border-top-right-radius:4px}\n    .shapla-modal-card__title{flex-grow:1;flex-shrink:0;font-size:1.5rem;font-weight:400;line-height:1;margin:0}\n    .shapla-modal-card__footer{border-bottom-left-radius:4px;border-bottom-right-radius:4px;\n    border-top:1px solid rgba(0,0,0,.12)}\n    .shapla-modal-card__footer.is-pulled-right{justify-content:flex-end}\n    .shapla-modal-card__footer.no-content{border-top:none;padding:2px}\n    .shapla-modal-card__body{background-color:#fff;flex-grow:1;flex-shrink:1;overflow:auto;padding:1rem}\n    .shapla-modal-box,.shapla-modal-confirm{background-color:#fff;border-radius:4px;\n    box-shadow:0 9px 46px 8px rgba(0,0,0,.14),0 11px 15px -7px rgba(0,0,0,.12),0 24px 38px 3px rgba(0,0,0,.2);padding:1rem}\n    .shapla-modal-confirm__content{padding:1rem;text-align:center}\n    .shapla-modal-confirm__icon{border:.25em solid var(--shapla-primary,#0d6efd);border-radius:50%;\n    color:var(--shapla-primary,#0d6efd);cursor:default;display:flex;height:5em;justify-content:center;\n    margin:1.25em auto 1.875em;-webkit-user-select:none;user-select:none;width:5em}\n    .shapla-modal-confirm__icon.is-success{border-color:var(--shapla-success,#198754);color:var(--shapla-success,#198754)}\n    .shapla-modal-confirm__icon.is-error{border-color:var(--shapla-error,#dc3545);color:var(--shapla-error,#dc3545)}\n    .shapla-modal-confirm__icon-content{align-items:center;display:flex;font-size:3.75em}\n    .shapla-modal-confirm__title{font-size:1.875em;margin:0 0 .4em;text-align:center}\n    .shapla-modal-confirm__actions{display:flex;justify-content:center;padding:1rem}\n    .shapla-modal-confirm__actions>*+*{margin-left:.5rem}"}}customElements.define("shapla-dialog",s);const a=(e,t,n)=>{t.length>2&&n.length&&e.removeAttribute("disabled")},l=document.querySelectorAll("[href*='post-new.php?post_type=carousels']");if(l){const e={title:"",type:""},t=(0,o.a)("button",{class:"shapla-button is-primary",disabled:""},["Next"]),n=(0,o.a)("button",{class:"shapla-button"},["Cancel"]),i=(0,o.a)("shapla-dialog",{type:"card","content-size":"large",heading:"Add New Carousel"},[(0,o.a)("div",{slot:"footer",class:"cs-flex cs-space-x-1"},[n,t])]);i.addEventListener("close",(()=>{i.removeAttribute("open")})),n.addEventListener("click",(()=>{i.removeAttribute("open")})),document.querySelector("body")?.append(i);const r=(0,o.a)("div",{class:"shapla-columns"},[(0,o.a)("div",{class:"shapla-column is-12-tablet"},[(0,o.a)("input",{type:"text",name:"slider_title",size:"30",value:"",id:"title",spellcheck:"true",autocomplete:"Off",placeholder:"Add Title",class:"widefat cs-py-2"})])]);i.append(r);const s=(0,o.a)("div",{class:"shapla-columns is-multiline"});i.append(s);let c=[];window.CarouselSliderL10n.sliderTypes.forEach((e=>{c.push((e=>{let t=(0,o.a)("span",{class:"option-slider-type__icon"});t.innerHTML=e.icon;let n={type:"radio",name:"slider_type",id:`_slide_type__${e.slug}`,class:"screen-reader-text",value:e.slug};return e.enabled||(n.disabled=""),(0,o.a)("div",{class:"shapla-column is-6-tablet is-4-desktop is-3-fullhd"},[(0,o.a)("input",n),(0,o.a)("label",{class:"option-slider-type",for:`_slide_type__${e.slug}`},[(0,o.a)("span",{class:"option-slider-type__content"},[t,(0,o.a)("span",{class:"option-slider-type__label"},[e.label]),e.pro?(0,o.a)("span",{class:"option-slider-type__pro"},["Pro"]):""])])])})(e))})),s.append(...c),l.forEach((e=>{e.addEventListener("click",(e=>{e.preventDefault(),i.setAttribute("open","")}))})),i.querySelectorAll('input[name="slider_title"]').forEach((n=>{n.addEventListener("input",(n=>{e.title=n.target.value,a(t,e.title,e.type)}))})),i.querySelectorAll('input[name="slider_type"]').forEach((n=>{n.addEventListener("change",(n=>{e.type=n.target.value,a(t,e.title,e.type)}))})),t.addEventListener("click",(n=>{t.hasAttribute("disabled")||(t.classList.add("is-loading"),fetch(window.CarouselSliderL10n.restRoot+"/carousels",{method:"POST",headers:{"Content-Type":"application/json","X-WP-Nonce":window.CarouselSliderL10n.restNonce},body:JSON.stringify(e)}).then((e=>e.json())).then((e=>{if(e.data.edit_link){let t=document.createElement("a");t.href=e.data.edit_link,t.click()}})).catch((e=>{console.error("Error:",e)})).finally((()=>{t.classList.remove("is-loading")})))}))}},639:()=>{function e(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var o=n.call(e,t||"default");if("object"!=typeof o)return o;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}new class{constructor(){e(this,"_previewContainer",void 0),e(this,"_formPost",void 0),e(this,"_previewMetaBox",void 0),e(this,"_iframeContainer",void 0),e(this,"_btnUpdatePreview",void 0),e(this,"_btnHidePreview",void 0),e(this,"_btnShowPreview",void 0),e(this,"_previewStatus","hidden"),e(this,"_postId",0),this._iframeContainer=document.querySelector("#carousel_slider_preview_iframe_container"),this._previewMetaBox=document.querySelector("#carousel-slider-live-preview"),this._btnUpdatePreview=document.querySelector("#carousel-slider-update-preview"),this._btnShowPreview=document.querySelector("#carousel-slider-show-preview"),this._btnHidePreview=document.querySelector("#carousel-slider-hide-preview"),this._previewContainer=document.querySelector("#carousel_slider_preview_meta_box"),this._formPost=document.body.querySelector("form#post"),this._iframeContainer&&this._btnUpdatePreview&&this._btnHidePreview&&this._formPost&&(this._postId=parseInt(this._btnShowPreview.dataset.id),this._btnShowPreview.addEventListener("click",(()=>this.onClickShowPreviewButton())),this._btnHidePreview.addEventListener("click",(()=>this.onClickHidePreviewButton())),this._btnUpdatePreview.addEventListener("click",(()=>this.onClickUpdatePreviewButton())),this._formPost.addEventListener("change",(()=>this.dispatchRefreshPreviewEvent())),document.body.addEventListener("CarouselSlider.refresh.preview",(()=>this.onRefreshPreview())))}getIframeUrl(){const e=new URL(window.CarouselSliderL10n.homeUrl);return e.searchParams.set("carousel_slider_preview","1"),e.searchParams.set("carousel_slider_iframe","1"),e.searchParams.set("slider_id",this._postId.toString()),e.toString()}getPreviewIframe(){const e=document.createElement("iframe");return e.setAttribute("id","carousel_slider_preview_iframe"),e.setAttribute("frameborder","0"),e.setAttribute("src",this.getIframeUrl()),e}refreshIframe(){const e=this._iframeContainer.offsetHeight;this._iframeContainer.style.height=e+"px",this._iframeContainer.innerHTML="",this._iframeContainer.appendChild(this.getPreviewIframe()),this._iframeContainer.style.height=""}onRefreshPreview(){this._previewStatus="updatable",this._btnHidePreview.classList.add("hidden"),this._btnShowPreview.classList.add("hidden"),this._btnUpdatePreview.classList.remove("hidden"),this._previewMetaBox.style.display="block"}onClickShowPreviewButton(){this._btnShowPreview.classList.add("hidden"),this._btnUpdatePreview.classList.add("hidden"),this._btnHidePreview.classList.remove("hidden"),this._previewMetaBox.style.display="block",this.getPreviewHtml().then((()=>{this._previewStatus="showing"}))}onClickHidePreviewButton(){this._previewStatus="hidden",this._btnHidePreview.classList.add("hidden"),this._btnUpdatePreview.classList.add("hidden"),this._btnShowPreview.classList.remove("hidden"),this._previewMetaBox.style.display="none"}onClickUpdatePreviewButton(){"hidden"!==this._previewStatus&&this.getPreviewHtml().then((()=>{this._previewStatus="showing",this._btnShowPreview.classList.add("hidden"),this._btnUpdatePreview.classList.add("hidden"),this._btnHidePreview.classList.remove("hidden"),this._previewMetaBox.style.display="block"}))}dispatchRefreshPreviewEvent(){document.body.dispatchEvent(new CustomEvent("CarouselSlider.refresh.preview"))}getPreviewHtml(){return new Promise(((e,t)=>{const n=document.body.querySelector("form#post");if(n){const o=new FormData(n);o.set("action","carousel_slider_preview_meta_box");const i=new URL(window.CarouselSliderL10n.ajaxUrl);i.searchParams.set("action","carousel_slider_preview_meta_box"),i.searchParams.set("cs_nonce",window.CarouselSliderL10n.nonce),fetch(i.toString(),{method:"POST",headers:{"X-WP-Nonce":window.CarouselSliderL10n.restNonce},body:o}).then((e=>e.json())).then((t=>{e(t.data),this.refreshIframe()})).catch((e=>{console.error("Error:",e),t(!1)}))}}))}}},669:e=>{"use strict";e.exports=jQuery},776:(e,t,n)=>{var o,i,r;i=[n(669)],void 0===(r="function"==typeof(o=function(e){var t=function(){if(e&&e.fn&&e.fn.select2&&e.fn.select2.amd)var t=e.fn.select2.amd;var n,o,i;return t&&t.requirejs||(t?o=t:t={},function(e){var t,r,s,a,l={},c={},d={},u={},p=Object.prototype.hasOwnProperty,h=[].slice,f=/\.js$/;function m(e,t){return p.call(e,t)}function g(e,t){var n,o,i,r,s,a,l,c,u,p,h,m=t&&t.split("/"),g=d.map,v=g&&g["*"]||{};if(e){for(s=(e=e.split("/")).length-1,d.nodeIdCompat&&f.test(e[s])&&(e[s]=e[s].replace(f,"")),"."===e[0].charAt(0)&&m&&(e=m.slice(0,m.length-1).concat(e)),u=0;u<e.length;u++)if("."===(h=e[u]))e.splice(u,1),u-=1;else if(".."===h){if(0===u||1===u&&".."===e[2]||".."===e[u-1])continue;u>0&&(e.splice(u-1,2),u-=2)}e=e.join("/")}if((m||v)&&g){for(u=(n=e.split("/")).length;u>0;u-=1){if(o=n.slice(0,u).join("/"),m)for(p=m.length;p>0;p-=1)if((i=g[m.slice(0,p).join("/")])&&(i=i[o])){r=i,a=u;break}if(r)break;!l&&v&&v[o]&&(l=v[o],c=u)}!r&&l&&(r=l,a=c),r&&(n.splice(0,a,r),e=n.join("/"))}return e}function v(t,n){return function(){var o=h.call(arguments,0);return"string"!=typeof o[0]&&1===o.length&&o.push(null),r.apply(e,o.concat([t,n]))}}function _(e){return function(t){return g(t,e)}}function y(e){return function(t){l[e]=t}}function b(n){if(m(c,n)){var o=c[n];delete c[n],u[n]=!0,t.apply(e,o)}if(!m(l,n)&&!m(u,n))throw new Error("No "+n);return l[n]}function w(e){var t,n=e?e.indexOf("!"):-1;return n>-1&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function x(e){return e?w(e):[]}function A(e){return function(){return d&&d.config&&d.config[e]||{}}}s=function(e,t){var n,o=w(e),i=o[0],r=t[1];return e=o[1],i&&(n=b(i=g(i,r))),i?e=n&&n.normalize?n.normalize(e,_(r)):g(e,r):(i=(o=w(e=g(e,r)))[0],e=o[1],i&&(n=b(i))),{f:i?i+"!"+e:e,n:e,pr:i,p:n}},a={require:function(e){return v(e)},exports:function(e){var t=l[e];return void 0!==t?t:l[e]={}},module:function(e){return{id:e,uri:"",exports:l[e],config:A(e)}}},t=function(t,n,o,i){var r,d,p,h,f,g,_,w=[],A=typeof o;if(g=x(i=i||t),"undefined"===A||"function"===A){for(n=!n.length&&o.length?["require","exports","module"]:n,f=0;f<n.length;f+=1)if("require"===(d=(h=s(n[f],g)).f))w[f]=a.require(t);else if("exports"===d)w[f]=a.exports(t),_=!0;else if("module"===d)r=w[f]=a.module(t);else if(m(l,d)||m(c,d)||m(u,d))w[f]=b(d);else{if(!h.p)throw new Error(t+" missing "+d);h.p.load(h.n,v(i,!0),y(d),{}),w[f]=l[d]}p=o?o.apply(l[t],w):void 0,t&&(r&&r.exports!==e&&r.exports!==l[t]?l[t]=r.exports:p===e&&_||(l[t]=p))}else t&&(l[t]=o)},n=o=r=function(n,o,i,l,c){if("string"==typeof n)return a[n]?a[n](o):b(s(n,x(o)).f);if(!n.splice){if((d=n).deps&&r(d.deps,d.callback),!o)return;o.splice?(n=o,o=i,i=null):n=e}return o=o||function(){},"function"==typeof i&&(i=l,l=c),l?t(e,n,o,i):setTimeout((function(){t(e,n,o,i)}),4),r},r.config=function(e){return r(e)},n._defined=l,(i=function(e,t,n){if("string"!=typeof e)throw new Error("See almond README: incorrect module build, no module name");t.splice||(n=t,t=[]),m(l,e)||m(c,e)||(c[e]=[e,t,n])}).amd={jQuery:!0}}(),t.requirejs=n,t.require=o,t.define=i),t.define("almond",(function(){})),t.define("jquery",[],(function(){var t=e||$;return null==t&&console&&console.error&&console.error("Select2: An instance of jQuery or a jQuery-compatible library was not found. Make sure that you are including jQuery before Select2 on your web page."),t})),t.define("select2/utils",["jquery"],(function(e){var t={};function n(e){var t=e.prototype,n=[];for(var o in t)"function"==typeof t[o]&&"constructor"!==o&&n.push(o);return n}t.Extend=function(e,t){var n={}.hasOwnProperty;function o(){this.constructor=e}for(var i in t)n.call(t,i)&&(e[i]=t[i]);return o.prototype=t.prototype,e.prototype=new o,e.__super__=t.prototype,e},t.Decorate=function(e,t){var o=n(t),i=n(e);function r(){var n=Array.prototype.unshift,o=t.prototype.constructor.length,i=e.prototype.constructor;o>0&&(n.call(arguments,e.prototype.constructor),i=t.prototype.constructor),i.apply(this,arguments)}function s(){this.constructor=r}t.displayName=e.displayName,r.prototype=new s;for(var a=0;a<i.length;a++){var l=i[a];r.prototype[l]=e.prototype[l]}for(var c=function(e){var n=function(){};e in r.prototype&&(n=r.prototype[e]);var o=t.prototype[e];return function(){return Array.prototype.unshift.call(arguments,n),o.apply(this,arguments)}},d=0;d<o.length;d++){var u=o[d];r.prototype[u]=c(u)}return r};var o=function(){this.listeners={}};o.prototype.on=function(e,t){this.listeners=this.listeners||{},e in this.listeners?this.listeners[e].push(t):this.listeners[e]=[t]},o.prototype.trigger=function(e){var t=Array.prototype.slice,n=t.call(arguments,1);this.listeners=this.listeners||{},null==n&&(n=[]),0===n.length&&n.push({}),n[0]._type=e,e in this.listeners&&this.invoke(this.listeners[e],t.call(arguments,1)),"*"in this.listeners&&this.invoke(this.listeners["*"],arguments)},o.prototype.invoke=function(e,t){for(var n=0,o=e.length;n<o;n++)e[n].apply(this,t)},t.Observable=o,t.generateChars=function(e){for(var t="",n=0;n<e;n++)t+=Math.floor(36*Math.random()).toString(36);return t},t.bind=function(e,t){return function(){e.apply(t,arguments)}},t._convertData=function(e){for(var t in e){var n=t.split("-"),o=e;if(1!==n.length){for(var i=0;i<n.length;i++){var r=n[i];(r=r.substring(0,1).toLowerCase()+r.substring(1))in o||(o[r]={}),i==n.length-1&&(o[r]=e[t]),o=o[r]}delete e[t]}}return e},t.hasScroll=function(t,n){var o=e(n),i=n.style.overflowX,r=n.style.overflowY;return(i!==r||"hidden"!==r&&"visible"!==r)&&("scroll"===i||"scroll"===r||o.innerHeight()<n.scrollHeight||o.innerWidth()<n.scrollWidth)},t.escapeMarkup=function(e){var t={"\\":"&#92;","&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#47;"};return"string"!=typeof e?e:String(e).replace(/[&<>"'\/\\]/g,(function(e){return t[e]}))},t.appendMany=function(t,n){if("1.7"===e.fn.jquery.substr(0,3)){var o=e();e.map(n,(function(e){o=o.add(e)})),n=o}t.append(n)},t.__cache={};var i=0;return t.GetUniqueElementId=function(e){var t=e.getAttribute("data-select2-id");return null==t&&(e.id?(t=e.id,e.setAttribute("data-select2-id",t)):(e.setAttribute("data-select2-id",++i),t=i.toString())),t},t.StoreData=function(e,n,o){var i=t.GetUniqueElementId(e);t.__cache[i]||(t.__cache[i]={}),t.__cache[i][n]=o},t.GetData=function(n,o){var i=t.GetUniqueElementId(n);return o?t.__cache[i]&&null!=t.__cache[i][o]?t.__cache[i][o]:e(n).data(o):t.__cache[i]},t.RemoveData=function(e){var n=t.GetUniqueElementId(e);null!=t.__cache[n]&&delete t.__cache[n],e.removeAttribute("data-select2-id")},t})),t.define("select2/results",["jquery","./utils"],(function(e,t){function n(e,t,o){this.$element=e,this.data=o,this.options=t,n.__super__.constructor.call(this)}return t.Extend(n,t.Observable),n.prototype.render=function(){var t=e('<ul class="select2-results__options" role="listbox"></ul>');return this.options.get("multiple")&&t.attr("aria-multiselectable","true"),this.$results=t,t},n.prototype.clear=function(){this.$results.empty()},n.prototype.displayMessage=function(t){var n=this.options.get("escapeMarkup");this.clear(),this.hideLoading();var o=e('<li role="alert" aria-live="assertive" class="select2-results__option"></li>'),i=this.options.get("translations").get(t.message);o.append(n(i(t.args))),o[0].className+=" select2-results__message",this.$results.append(o)},n.prototype.hideMessages=function(){this.$results.find(".select2-results__message").remove()},n.prototype.append=function(e){this.hideLoading();var t=[];if(null!=e.results&&0!==e.results.length){e.results=this.sort(e.results);for(var n=0;n<e.results.length;n++){var o=e.results[n],i=this.option(o);t.push(i)}this.$results.append(t)}else 0===this.$results.children().length&&this.trigger("results:message",{message:"noResults"})},n.prototype.position=function(e,t){t.find(".select2-results").append(e)},n.prototype.sort=function(e){return this.options.get("sorter")(e)},n.prototype.highlightFirstItem=function(){var e=this.$results.find(".select2-results__option[aria-selected]"),t=e.filter("[aria-selected=true]");t.length>0?t.first().trigger("mouseenter"):e.first().trigger("mouseenter"),this.ensureHighlightVisible()},n.prototype.setClasses=function(){var n=this;this.data.current((function(o){var i=e.map(o,(function(e){return e.id.toString()}));n.$results.find(".select2-results__option[aria-selected]").each((function(){var n=e(this),o=t.GetData(this,"data"),r=""+o.id;null!=o.element&&o.element.selected||null==o.element&&e.inArray(r,i)>-1?n.attr("aria-selected","true"):n.attr("aria-selected","false")}))}))},n.prototype.showLoading=function(e){this.hideLoading();var t={disabled:!0,loading:!0,text:this.options.get("translations").get("searching")(e)},n=this.option(t);n.className+=" loading-results",this.$results.prepend(n)},n.prototype.hideLoading=function(){this.$results.find(".loading-results").remove()},n.prototype.option=function(n){var o=document.createElement("li");o.className="select2-results__option";var i={role:"option","aria-selected":"false"},r=window.Element.prototype.matches||window.Element.prototype.msMatchesSelector||window.Element.prototype.webkitMatchesSelector;for(var s in(null!=n.element&&r.call(n.element,":disabled")||null==n.element&&n.disabled)&&(delete i["aria-selected"],i["aria-disabled"]="true"),null==n.id&&delete i["aria-selected"],null!=n._resultId&&(o.id=n._resultId),n.title&&(o.title=n.title),n.children&&(i.role="group",i["aria-label"]=n.text,delete i["aria-selected"]),i){var a=i[s];o.setAttribute(s,a)}if(n.children){var l=e(o),c=document.createElement("strong");c.className="select2-results__group",e(c),this.template(n,c);for(var d=[],u=0;u<n.children.length;u++){var p=n.children[u],h=this.option(p);d.push(h)}var f=e("<ul></ul>",{class:"select2-results__options select2-results__options--nested"});f.append(d),l.append(c),l.append(f)}else this.template(n,o);return t.StoreData(o,"data",n),o},n.prototype.bind=function(n,o){var i=this,r=n.id+"-results";this.$results.attr("id",r),n.on("results:all",(function(e){i.clear(),i.append(e.data),n.isOpen()&&(i.setClasses(),i.highlightFirstItem())})),n.on("results:append",(function(e){i.append(e.data),n.isOpen()&&i.setClasses()})),n.on("query",(function(e){i.hideMessages(),i.showLoading(e)})),n.on("select",(function(){n.isOpen()&&(i.setClasses(),i.options.get("scrollAfterSelect")&&i.highlightFirstItem())})),n.on("unselect",(function(){n.isOpen()&&(i.setClasses(),i.options.get("scrollAfterSelect")&&i.highlightFirstItem())})),n.on("open",(function(){i.$results.attr("aria-expanded","true"),i.$results.attr("aria-hidden","false"),i.setClasses(),i.ensureHighlightVisible()})),n.on("close",(function(){i.$results.attr("aria-expanded","false"),i.$results.attr("aria-hidden","true"),i.$results.removeAttr("aria-activedescendant")})),n.on("results:toggle",(function(){var e=i.getHighlightedResults();0!==e.length&&e.trigger("mouseup")})),n.on("results:select",(function(){var e=i.getHighlightedResults();if(0!==e.length){var n=t.GetData(e[0],"data");"true"==e.attr("aria-selected")?i.trigger("close",{}):i.trigger("select",{data:n})}})),n.on("results:previous",(function(){var e=i.getHighlightedResults(),t=i.$results.find("[aria-selected]"),n=t.index(e);if(!(n<=0)){var o=n-1;0===e.length&&(o=0);var r=t.eq(o);r.trigger("mouseenter");var s=i.$results.offset().top,a=r.offset().top,l=i.$results.scrollTop()+(a-s);0===o?i.$results.scrollTop(0):a-s<0&&i.$results.scrollTop(l)}})),n.on("results:next",(function(){var e=i.getHighlightedResults(),t=i.$results.find("[aria-selected]"),n=t.index(e)+1;if(!(n>=t.length)){var o=t.eq(n);o.trigger("mouseenter");var r=i.$results.offset().top+i.$results.outerHeight(!1),s=o.offset().top+o.outerHeight(!1),a=i.$results.scrollTop()+s-r;0===n?i.$results.scrollTop(0):s>r&&i.$results.scrollTop(a)}})),n.on("results:focus",(function(e){e.element.addClass("select2-results__option--highlighted")})),n.on("results:message",(function(e){i.displayMessage(e)})),e.fn.mousewheel&&this.$results.on("mousewheel",(function(e){var t=i.$results.scrollTop(),n=i.$results.get(0).scrollHeight-t+e.deltaY,o=e.deltaY>0&&t-e.deltaY<=0,r=e.deltaY<0&&n<=i.$results.height();o?(i.$results.scrollTop(0),e.preventDefault(),e.stopPropagation()):r&&(i.$results.scrollTop(i.$results.get(0).scrollHeight-i.$results.height()),e.preventDefault(),e.stopPropagation())})),this.$results.on("mouseup",".select2-results__option[aria-selected]",(function(n){var o=e(this),r=t.GetData(this,"data");"true"!==o.attr("aria-selected")?i.trigger("select",{originalEvent:n,data:r}):i.options.get("multiple")?i.trigger("unselect",{originalEvent:n,data:r}):i.trigger("close",{})})),this.$results.on("mouseenter",".select2-results__option[aria-selected]",(function(n){var o=t.GetData(this,"data");i.getHighlightedResults().removeClass("select2-results__option--highlighted"),i.trigger("results:focus",{data:o,element:e(this)})}))},n.prototype.getHighlightedResults=function(){return this.$results.find(".select2-results__option--highlighted")},n.prototype.destroy=function(){this.$results.remove()},n.prototype.ensureHighlightVisible=function(){var e=this.getHighlightedResults();if(0!==e.length){var t=this.$results.find("[aria-selected]").index(e),n=this.$results.offset().top,o=e.offset().top,i=this.$results.scrollTop()+(o-n),r=o-n;i-=2*e.outerHeight(!1),t<=2?this.$results.scrollTop(0):(r>this.$results.outerHeight()||r<0)&&this.$results.scrollTop(i)}},n.prototype.template=function(t,n){var o=this.options.get("templateResult"),i=this.options.get("escapeMarkup"),r=o(t,n);null==r?n.style.display="none":"string"==typeof r?n.innerHTML=i(r):e(n).append(r)},n})),t.define("select2/keys",[],(function(){return{BACKSPACE:8,TAB:9,ENTER:13,SHIFT:16,CTRL:17,ALT:18,ESC:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40,DELETE:46}})),t.define("select2/selection/base",["jquery","../utils","../keys"],(function(e,t,n){function o(e,t){this.$element=e,this.options=t,o.__super__.constructor.call(this)}return t.Extend(o,t.Observable),o.prototype.render=function(){var n=e('<span class="select2-selection" role="combobox"  aria-haspopup="true" aria-expanded="false"></span>');return this._tabindex=0,null!=t.GetData(this.$element[0],"old-tabindex")?this._tabindex=t.GetData(this.$element[0],"old-tabindex"):null!=this.$element.attr("tabindex")&&(this._tabindex=this.$element.attr("tabindex")),n.attr("title",this.$element.attr("title")),n.attr("tabindex",this._tabindex),n.attr("aria-disabled","false"),this.$selection=n,n},o.prototype.bind=function(e,t){var o=this,i=e.id+"-results";this.container=e,this.$selection.on("focus",(function(e){o.trigger("focus",e)})),this.$selection.on("blur",(function(e){o._handleBlur(e)})),this.$selection.on("keydown",(function(e){o.trigger("keypress",e),e.which===n.SPACE&&e.preventDefault()})),e.on("results:focus",(function(e){o.$selection.attr("aria-activedescendant",e.data._resultId)})),e.on("selection:update",(function(e){o.update(e.data)})),e.on("open",(function(){o.$selection.attr("aria-expanded","true"),o.$selection.attr("aria-owns",i),o._attachCloseHandler(e)})),e.on("close",(function(){o.$selection.attr("aria-expanded","false"),o.$selection.removeAttr("aria-activedescendant"),o.$selection.removeAttr("aria-owns"),o.$selection.trigger("focus"),o._detachCloseHandler(e)})),e.on("enable",(function(){o.$selection.attr("tabindex",o._tabindex),o.$selection.attr("aria-disabled","false")})),e.on("disable",(function(){o.$selection.attr("tabindex","-1"),o.$selection.attr("aria-disabled","true")}))},o.prototype._handleBlur=function(t){var n=this;window.setTimeout((function(){document.activeElement==n.$selection[0]||e.contains(n.$selection[0],document.activeElement)||n.trigger("blur",t)}),1)},o.prototype._attachCloseHandler=function(n){e(document.body).on("mousedown.select2."+n.id,(function(n){var o=e(n.target).closest(".select2");e(".select2.select2-container--open").each((function(){this!=o[0]&&t.GetData(this,"element").select2("close")}))}))},o.prototype._detachCloseHandler=function(t){e(document.body).off("mousedown.select2."+t.id)},o.prototype.position=function(e,t){t.find(".selection").append(e)},o.prototype.destroy=function(){this._detachCloseHandler(this.container)},o.prototype.update=function(e){throw new Error("The `update` method must be defined in child classes.")},o.prototype.isEnabled=function(){return!this.isDisabled()},o.prototype.isDisabled=function(){return this.options.get("disabled")},o})),t.define("select2/selection/single",["jquery","./base","../utils","../keys"],(function(e,t,n,o){function i(){i.__super__.constructor.apply(this,arguments)}return n.Extend(i,t),i.prototype.render=function(){var e=i.__super__.render.call(this);return e.addClass("select2-selection--single"),e.html('<span class="select2-selection__rendered"></span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span>'),e},i.prototype.bind=function(e,t){var n=this;i.__super__.bind.apply(this,arguments);var o=e.id+"-container";this.$selection.find(".select2-selection__rendered").attr("id",o).attr("role","textbox").attr("aria-readonly","true"),this.$selection.attr("aria-labelledby",o),this.$selection.on("mousedown",(function(e){1===e.which&&n.trigger("toggle",{originalEvent:e})})),this.$selection.on("focus",(function(e){})),this.$selection.on("blur",(function(e){})),e.on("focus",(function(t){e.isOpen()||n.$selection.trigger("focus")}))},i.prototype.clear=function(){var e=this.$selection.find(".select2-selection__rendered");e.empty(),e.removeAttr("title")},i.prototype.display=function(e,t){var n=this.options.get("templateSelection");return this.options.get("escapeMarkup")(n(e,t))},i.prototype.selectionContainer=function(){return e("<span></span>")},i.prototype.update=function(e){if(0!==e.length){var t=e[0],n=this.$selection.find(".select2-selection__rendered"),o=this.display(t,n);n.empty().append(o);var i=t.title||t.text;i?n.attr("title",i):n.removeAttr("title")}else this.clear()},i})),t.define("select2/selection/multiple",["jquery","./base","../utils"],(function(e,t,n){function o(e,t){o.__super__.constructor.apply(this,arguments)}return n.Extend(o,t),o.prototype.render=function(){var e=o.__super__.render.call(this);return e.addClass("select2-selection--multiple"),e.html('<ul class="select2-selection__rendered"></ul>'),e},o.prototype.bind=function(t,i){var r=this;o.__super__.bind.apply(this,arguments),this.$selection.on("click",(function(e){r.trigger("toggle",{originalEvent:e})})),this.$selection.on("click",".select2-selection__choice__remove",(function(t){if(!r.isDisabled()){var o=e(this).parent(),i=n.GetData(o[0],"data");r.trigger("unselect",{originalEvent:t,data:i})}}))},o.prototype.clear=function(){var e=this.$selection.find(".select2-selection__rendered");e.empty(),e.removeAttr("title")},o.prototype.display=function(e,t){var n=this.options.get("templateSelection");return this.options.get("escapeMarkup")(n(e,t))},o.prototype.selectionContainer=function(){return e('<li class="select2-selection__choice"><span class="select2-selection__choice__remove" role="presentation">&times;</span></li>')},o.prototype.update=function(e){if(this.clear(),0!==e.length){for(var t=[],o=0;o<e.length;o++){var i=e[o],r=this.selectionContainer(),s=this.display(i,r);r.append(s);var a=i.title||i.text;a&&r.attr("title",a),n.StoreData(r[0],"data",i),t.push(r)}var l=this.$selection.find(".select2-selection__rendered");n.appendMany(l,t)}},o})),t.define("select2/selection/placeholder",["../utils"],(function(e){function t(e,t,n){this.placeholder=this.normalizePlaceholder(n.get("placeholder")),e.call(this,t,n)}return t.prototype.normalizePlaceholder=function(e,t){return"string"==typeof t&&(t={id:"",text:t}),t},t.prototype.createPlaceholder=function(e,t){var n=this.selectionContainer();return n.html(this.display(t)),n.addClass("select2-selection__placeholder").removeClass("select2-selection__choice"),n},t.prototype.update=function(e,t){var n=1==t.length&&t[0].id!=this.placeholder.id;if(t.length>1||n)return e.call(this,t);this.clear();var o=this.createPlaceholder(this.placeholder);this.$selection.find(".select2-selection__rendered").append(o)},t})),t.define("select2/selection/allowClear",["jquery","../keys","../utils"],(function(e,t,n){function o(){}return o.prototype.bind=function(e,t,n){var o=this;e.call(this,t,n),null==this.placeholder&&this.options.get("debug")&&window.console&&console.error&&console.error("Select2: The `allowClear` option should be used in combination with the `placeholder` option."),this.$selection.on("mousedown",".select2-selection__clear",(function(e){o._handleClear(e)})),t.on("keypress",(function(e){o._handleKeyboardClear(e,t)}))},o.prototype._handleClear=function(e,t){if(!this.isDisabled()){var o=this.$selection.find(".select2-selection__clear");if(0!==o.length){t.stopPropagation();var i=n.GetData(o[0],"data"),r=this.$element.val();this.$element.val(this.placeholder.id);var s={data:i};if(this.trigger("clear",s),s.prevented)this.$element.val(r);else{for(var a=0;a<i.length;a++)if(s={data:i[a]},this.trigger("unselect",s),s.prevented)return void this.$element.val(r);this.$element.trigger("input").trigger("change"),this.trigger("toggle",{})}}}},o.prototype._handleKeyboardClear=function(e,n,o){o.isOpen()||n.which!=t.DELETE&&n.which!=t.BACKSPACE||this._handleClear(n)},o.prototype.update=function(t,o){if(t.call(this,o),!(this.$selection.find(".select2-selection__placeholder").length>0||0===o.length)){var i=this.options.get("translations").get("removeAllItems"),r=e('<span class="select2-selection__clear" title="'+i()+'">&times;</span>');n.StoreData(r[0],"data",o),this.$selection.find(".select2-selection__rendered").prepend(r)}},o})),t.define("select2/selection/search",["jquery","../utils","../keys"],(function(e,t,n){function o(e,t,n){e.call(this,t,n)}return o.prototype.render=function(t){var n=e('<li class="select2-search select2-search--inline"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false" role="searchbox" aria-autocomplete="list" /></li>');this.$searchContainer=n,this.$search=n.find("input");var o=t.call(this);return this._transferTabIndex(),o},o.prototype.bind=function(e,o,i){var r=this,s=o.id+"-results";e.call(this,o,i),o.on("open",(function(){r.$search.attr("aria-controls",s),r.$search.trigger("focus")})),o.on("close",(function(){r.$search.val(""),r.$search.removeAttr("aria-controls"),r.$search.removeAttr("aria-activedescendant"),r.$search.trigger("focus")})),o.on("enable",(function(){r.$search.prop("disabled",!1),r._transferTabIndex()})),o.on("disable",(function(){r.$search.prop("disabled",!0)})),o.on("focus",(function(e){r.$search.trigger("focus")})),o.on("results:focus",(function(e){e.data._resultId?r.$search.attr("aria-activedescendant",e.data._resultId):r.$search.removeAttr("aria-activedescendant")})),this.$selection.on("focusin",".select2-search--inline",(function(e){r.trigger("focus",e)})),this.$selection.on("focusout",".select2-search--inline",(function(e){r._handleBlur(e)})),this.$selection.on("keydown",".select2-search--inline",(function(e){if(e.stopPropagation(),r.trigger("keypress",e),r._keyUpPrevented=e.isDefaultPrevented(),e.which===n.BACKSPACE&&""===r.$search.val()){var o=r.$searchContainer.prev(".select2-selection__choice");if(o.length>0){var i=t.GetData(o[0],"data");r.searchRemoveChoice(i),e.preventDefault()}}})),this.$selection.on("click",".select2-search--inline",(function(e){r.$search.val()&&e.stopPropagation()}));var a=document.documentMode,l=a&&a<=11;this.$selection.on("input.searchcheck",".select2-search--inline",(function(e){l?r.$selection.off("input.search input.searchcheck"):r.$selection.off("keyup.search")})),this.$selection.on("keyup.search input.search",".select2-search--inline",(function(e){if(l&&"input"===e.type)r.$selection.off("input.search input.searchcheck");else{var t=e.which;t!=n.SHIFT&&t!=n.CTRL&&t!=n.ALT&&t!=n.TAB&&r.handleSearch(e)}}))},o.prototype._transferTabIndex=function(e){this.$search.attr("tabindex",this.$selection.attr("tabindex")),this.$selection.attr("tabindex","-1")},o.prototype.createPlaceholder=function(e,t){this.$search.attr("placeholder",t.text)},o.prototype.update=function(e,t){var n=this.$search[0]==document.activeElement;this.$search.attr("placeholder",""),e.call(this,t),this.$selection.find(".select2-selection__rendered").append(this.$searchContainer),this.resizeSearch(),n&&this.$search.trigger("focus")},o.prototype.handleSearch=function(){if(this.resizeSearch(),!this._keyUpPrevented){var e=this.$search.val();this.trigger("query",{term:e})}this._keyUpPrevented=!1},o.prototype.searchRemoveChoice=function(e,t){this.trigger("unselect",{data:t}),this.$search.val(t.text),this.handleSearch()},o.prototype.resizeSearch=function(){this.$search.css("width","25px");var e="";e=""!==this.$search.attr("placeholder")?this.$selection.find(".select2-selection__rendered").width():.75*(this.$search.val().length+1)+"em",this.$search.css("width",e)},o})),t.define("select2/selection/eventRelay",["jquery"],(function(e){function t(){}return t.prototype.bind=function(t,n,o){var i=this,r=["open","opening","close","closing","select","selecting","unselect","unselecting","clear","clearing"],s=["opening","closing","selecting","unselecting","clearing"];t.call(this,n,o),n.on("*",(function(t,n){if(-1!==e.inArray(t,r)){n=n||{};var o=e.Event("select2:"+t,{params:n});i.$element.trigger(o),-1!==e.inArray(t,s)&&(n.prevented=o.isDefaultPrevented())}}))},t})),t.define("select2/translation",["jquery","require"],(function(e,t){function n(e){this.dict=e||{}}return n.prototype.all=function(){return this.dict},n.prototype.get=function(e){return this.dict[e]},n.prototype.extend=function(t){this.dict=e.extend({},t.all(),this.dict)},n._cache={},n.loadPath=function(e){if(!(e in n._cache)){var o=t(e);n._cache[e]=o}return new n(n._cache[e])},n})),t.define("select2/diacritics",[],(function(){return{"Ⓐ":"A",Ａ:"A",À:"A",Á:"A",Â:"A",Ầ:"A",Ấ:"A",Ẫ:"A",Ẩ:"A",Ã:"A",Ā:"A",Ă:"A",Ằ:"A",Ắ:"A",Ẵ:"A",Ẳ:"A",Ȧ:"A",Ǡ:"A",Ä:"A",Ǟ:"A",Ả:"A",Å:"A",Ǻ:"A",Ǎ:"A",Ȁ:"A",Ȃ:"A",Ạ:"A",Ậ:"A",Ặ:"A",Ḁ:"A",Ą:"A",Ⱥ:"A",Ɐ:"A",Ꜳ:"AA",Æ:"AE",Ǽ:"AE",Ǣ:"AE",Ꜵ:"AO",Ꜷ:"AU",Ꜹ:"AV",Ꜻ:"AV",Ꜽ:"AY","Ⓑ":"B",Ｂ:"B",Ḃ:"B",Ḅ:"B",Ḇ:"B",Ƀ:"B",Ƃ:"B",Ɓ:"B","Ⓒ":"C",Ｃ:"C",Ć:"C",Ĉ:"C",Ċ:"C",Č:"C",Ç:"C",Ḉ:"C",Ƈ:"C",Ȼ:"C",Ꜿ:"C","Ⓓ":"D",Ｄ:"D",Ḋ:"D",Ď:"D",Ḍ:"D",Ḑ:"D",Ḓ:"D",Ḏ:"D",Đ:"D",Ƌ:"D",Ɗ:"D",Ɖ:"D",Ꝺ:"D",Ǳ:"DZ",Ǆ:"DZ",ǲ:"Dz",ǅ:"Dz","Ⓔ":"E",Ｅ:"E",È:"E",É:"E",Ê:"E",Ề:"E",Ế:"E",Ễ:"E",Ể:"E",Ẽ:"E",Ē:"E",Ḕ:"E",Ḗ:"E",Ĕ:"E",Ė:"E",Ë:"E",Ẻ:"E",Ě:"E",Ȅ:"E",Ȇ:"E",Ẹ:"E",Ệ:"E",Ȩ:"E",Ḝ:"E",Ę:"E",Ḙ:"E",Ḛ:"E",Ɛ:"E",Ǝ:"E","Ⓕ":"F",Ｆ:"F",Ḟ:"F",Ƒ:"F",Ꝼ:"F","Ⓖ":"G",Ｇ:"G",Ǵ:"G",Ĝ:"G",Ḡ:"G",Ğ:"G",Ġ:"G",Ǧ:"G",Ģ:"G",Ǥ:"G",Ɠ:"G",Ꞡ:"G",Ᵹ:"G",Ꝿ:"G","Ⓗ":"H",Ｈ:"H",Ĥ:"H",Ḣ:"H",Ḧ:"H",Ȟ:"H",Ḥ:"H",Ḩ:"H",Ḫ:"H",Ħ:"H",Ⱨ:"H",Ⱶ:"H",Ɥ:"H","Ⓘ":"I",Ｉ:"I",Ì:"I",Í:"I",Î:"I",Ĩ:"I",Ī:"I",Ĭ:"I",İ:"I",Ï:"I",Ḯ:"I",Ỉ:"I",Ǐ:"I",Ȉ:"I",Ȋ:"I",Ị:"I",Į:"I",Ḭ:"I",Ɨ:"I","Ⓙ":"J",Ｊ:"J",Ĵ:"J",Ɉ:"J","Ⓚ":"K",Ｋ:"K",Ḱ:"K",Ǩ:"K",Ḳ:"K",Ķ:"K",Ḵ:"K",Ƙ:"K",Ⱪ:"K",Ꝁ:"K",Ꝃ:"K",Ꝅ:"K",Ꞣ:"K","Ⓛ":"L",Ｌ:"L",Ŀ:"L",Ĺ:"L",Ľ:"L",Ḷ:"L",Ḹ:"L",Ļ:"L",Ḽ:"L",Ḻ:"L",Ł:"L",Ƚ:"L",Ɫ:"L",Ⱡ:"L",Ꝉ:"L",Ꝇ:"L",Ꞁ:"L",Ǉ:"LJ",ǈ:"Lj","Ⓜ":"M",Ｍ:"M",Ḿ:"M",Ṁ:"M",Ṃ:"M",Ɱ:"M",Ɯ:"M","Ⓝ":"N",Ｎ:"N",Ǹ:"N",Ń:"N",Ñ:"N",Ṅ:"N",Ň:"N",Ṇ:"N",Ņ:"N",Ṋ:"N",Ṉ:"N",Ƞ:"N",Ɲ:"N",Ꞑ:"N",Ꞥ:"N",Ǌ:"NJ",ǋ:"Nj","Ⓞ":"O",Ｏ:"O",Ò:"O",Ó:"O",Ô:"O",Ồ:"O",Ố:"O",Ỗ:"O",Ổ:"O",Õ:"O",Ṍ:"O",Ȭ:"O",Ṏ:"O",Ō:"O",Ṑ:"O",Ṓ:"O",Ŏ:"O",Ȯ:"O",Ȱ:"O",Ö:"O",Ȫ:"O",Ỏ:"O",Ő:"O",Ǒ:"O",Ȍ:"O",Ȏ:"O",Ơ:"O",Ờ:"O",Ớ:"O",Ỡ:"O",Ở:"O",Ợ:"O",Ọ:"O",Ộ:"O",Ǫ:"O",Ǭ:"O",Ø:"O",Ǿ:"O",Ɔ:"O",Ɵ:"O",Ꝋ:"O",Ꝍ:"O",Œ:"OE",Ƣ:"OI",Ꝏ:"OO",Ȣ:"OU","Ⓟ":"P",Ｐ:"P",Ṕ:"P",Ṗ:"P",Ƥ:"P",Ᵽ:"P",Ꝑ:"P",Ꝓ:"P",Ꝕ:"P","Ⓠ":"Q",Ｑ:"Q",Ꝗ:"Q",Ꝙ:"Q",Ɋ:"Q","Ⓡ":"R",Ｒ:"R",Ŕ:"R",Ṙ:"R",Ř:"R",Ȑ:"R",Ȓ:"R",Ṛ:"R",Ṝ:"R",Ŗ:"R",Ṟ:"R",Ɍ:"R",Ɽ:"R",Ꝛ:"R",Ꞧ:"R",Ꞃ:"R","Ⓢ":"S",Ｓ:"S",ẞ:"S",Ś:"S",Ṥ:"S",Ŝ:"S",Ṡ:"S",Š:"S",Ṧ:"S",Ṣ:"S",Ṩ:"S",Ș:"S",Ş:"S",Ȿ:"S",Ꞩ:"S",Ꞅ:"S","Ⓣ":"T",Ｔ:"T",Ṫ:"T",Ť:"T",Ṭ:"T",Ț:"T",Ţ:"T",Ṱ:"T",Ṯ:"T",Ŧ:"T",Ƭ:"T",Ʈ:"T",Ⱦ:"T",Ꞇ:"T",Ꜩ:"TZ","Ⓤ":"U",Ｕ:"U",Ù:"U",Ú:"U",Û:"U",Ũ:"U",Ṹ:"U",Ū:"U",Ṻ:"U",Ŭ:"U",Ü:"U",Ǜ:"U",Ǘ:"U",Ǖ:"U",Ǚ:"U",Ủ:"U",Ů:"U",Ű:"U",Ǔ:"U",Ȕ:"U",Ȗ:"U",Ư:"U",Ừ:"U",Ứ:"U",Ữ:"U",Ử:"U",Ự:"U",Ụ:"U",Ṳ:"U",Ų:"U",Ṷ:"U",Ṵ:"U",Ʉ:"U","Ⓥ":"V",Ｖ:"V",Ṽ:"V",Ṿ:"V",Ʋ:"V",Ꝟ:"V",Ʌ:"V",Ꝡ:"VY","Ⓦ":"W",Ｗ:"W",Ẁ:"W",Ẃ:"W",Ŵ:"W",Ẇ:"W",Ẅ:"W",Ẉ:"W",Ⱳ:"W","Ⓧ":"X",Ｘ:"X",Ẋ:"X",Ẍ:"X","Ⓨ":"Y",Ｙ:"Y",Ỳ:"Y",Ý:"Y",Ŷ:"Y",Ỹ:"Y",Ȳ:"Y",Ẏ:"Y",Ÿ:"Y",Ỷ:"Y",Ỵ:"Y",Ƴ:"Y",Ɏ:"Y",Ỿ:"Y","Ⓩ":"Z",Ｚ:"Z",Ź:"Z",Ẑ:"Z",Ż:"Z",Ž:"Z",Ẓ:"Z",Ẕ:"Z",Ƶ:"Z",Ȥ:"Z",Ɀ:"Z",Ⱬ:"Z",Ꝣ:"Z","ⓐ":"a",ａ:"a",ẚ:"a",à:"a",á:"a",â:"a",ầ:"a",ấ:"a",ẫ:"a",ẩ:"a",ã:"a",ā:"a",ă:"a",ằ:"a",ắ:"a",ẵ:"a",ẳ:"a",ȧ:"a",ǡ:"a",ä:"a",ǟ:"a",ả:"a",å:"a",ǻ:"a",ǎ:"a",ȁ:"a",ȃ:"a",ạ:"a",ậ:"a",ặ:"a",ḁ:"a",ą:"a",ⱥ:"a",ɐ:"a",ꜳ:"aa",æ:"ae",ǽ:"ae",ǣ:"ae",ꜵ:"ao",ꜷ:"au",ꜹ:"av",ꜻ:"av",ꜽ:"ay","ⓑ":"b",ｂ:"b",ḃ:"b",ḅ:"b",ḇ:"b",ƀ:"b",ƃ:"b",ɓ:"b","ⓒ":"c",ｃ:"c",ć:"c",ĉ:"c",ċ:"c",č:"c",ç:"c",ḉ:"c",ƈ:"c",ȼ:"c",ꜿ:"c",ↄ:"c","ⓓ":"d",ｄ:"d",ḋ:"d",ď:"d",ḍ:"d",ḑ:"d",ḓ:"d",ḏ:"d",đ:"d",ƌ:"d",ɖ:"d",ɗ:"d",ꝺ:"d",ǳ:"dz",ǆ:"dz","ⓔ":"e",ｅ:"e",è:"e",é:"e",ê:"e",ề:"e",ế:"e",ễ:"e",ể:"e",ẽ:"e",ē:"e",ḕ:"e",ḗ:"e",ĕ:"e",ė:"e",ë:"e",ẻ:"e",ě:"e",ȅ:"e",ȇ:"e",ẹ:"e",ệ:"e",ȩ:"e",ḝ:"e",ę:"e",ḙ:"e",ḛ:"e",ɇ:"e",ɛ:"e",ǝ:"e","ⓕ":"f",ｆ:"f",ḟ:"f",ƒ:"f",ꝼ:"f","ⓖ":"g",ｇ:"g",ǵ:"g",ĝ:"g",ḡ:"g",ğ:"g",ġ:"g",ǧ:"g",ģ:"g",ǥ:"g",ɠ:"g",ꞡ:"g",ᵹ:"g",ꝿ:"g","ⓗ":"h",ｈ:"h",ĥ:"h",ḣ:"h",ḧ:"h",ȟ:"h",ḥ:"h",ḩ:"h",ḫ:"h",ẖ:"h",ħ:"h",ⱨ:"h",ⱶ:"h",ɥ:"h",ƕ:"hv","ⓘ":"i",ｉ:"i",ì:"i",í:"i",î:"i",ĩ:"i",ī:"i",ĭ:"i",ï:"i",ḯ:"i",ỉ:"i",ǐ:"i",ȉ:"i",ȋ:"i",ị:"i",į:"i",ḭ:"i",ɨ:"i",ı:"i","ⓙ":"j",ｊ:"j",ĵ:"j",ǰ:"j",ɉ:"j","ⓚ":"k",ｋ:"k",ḱ:"k",ǩ:"k",ḳ:"k",ķ:"k",ḵ:"k",ƙ:"k",ⱪ:"k",ꝁ:"k",ꝃ:"k",ꝅ:"k",ꞣ:"k","ⓛ":"l",ｌ:"l",ŀ:"l",ĺ:"l",ľ:"l",ḷ:"l",ḹ:"l",ļ:"l",ḽ:"l",ḻ:"l",ſ:"l",ł:"l",ƚ:"l",ɫ:"l",ⱡ:"l",ꝉ:"l",ꞁ:"l",ꝇ:"l",ǉ:"lj","ⓜ":"m",ｍ:"m",ḿ:"m",ṁ:"m",ṃ:"m",ɱ:"m",ɯ:"m","ⓝ":"n",ｎ:"n",ǹ:"n",ń:"n",ñ:"n",ṅ:"n",ň:"n",ṇ:"n",ņ:"n",ṋ:"n",ṉ:"n",ƞ:"n",ɲ:"n",ŉ:"n",ꞑ:"n",ꞥ:"n",ǌ:"nj","ⓞ":"o",ｏ:"o",ò:"o",ó:"o",ô:"o",ồ:"o",ố:"o",ỗ:"o",ổ:"o",õ:"o",ṍ:"o",ȭ:"o",ṏ:"o",ō:"o",ṑ:"o",ṓ:"o",ŏ:"o",ȯ:"o",ȱ:"o",ö:"o",ȫ:"o",ỏ:"o",ő:"o",ǒ:"o",ȍ:"o",ȏ:"o",ơ:"o",ờ:"o",ớ:"o",ỡ:"o",ở:"o",ợ:"o",ọ:"o",ộ:"o",ǫ:"o",ǭ:"o",ø:"o",ǿ:"o",ɔ:"o",ꝋ:"o",ꝍ:"o",ɵ:"o",œ:"oe",ƣ:"oi",ȣ:"ou",ꝏ:"oo","ⓟ":"p",ｐ:"p",ṕ:"p",ṗ:"p",ƥ:"p",ᵽ:"p",ꝑ:"p",ꝓ:"p",ꝕ:"p","ⓠ":"q",ｑ:"q",ɋ:"q",ꝗ:"q",ꝙ:"q","ⓡ":"r",ｒ:"r",ŕ:"r",ṙ:"r",ř:"r",ȑ:"r",ȓ:"r",ṛ:"r",ṝ:"r",ŗ:"r",ṟ:"r",ɍ:"r",ɽ:"r",ꝛ:"r",ꞧ:"r",ꞃ:"r","ⓢ":"s",ｓ:"s",ß:"s",ś:"s",ṥ:"s",ŝ:"s",ṡ:"s",š:"s",ṧ:"s",ṣ:"s",ṩ:"s",ș:"s",ş:"s",ȿ:"s",ꞩ:"s",ꞅ:"s",ẛ:"s","ⓣ":"t",ｔ:"t",ṫ:"t",ẗ:"t",ť:"t",ṭ:"t",ț:"t",ţ:"t",ṱ:"t",ṯ:"t",ŧ:"t",ƭ:"t",ʈ:"t",ⱦ:"t",ꞇ:"t",ꜩ:"tz","ⓤ":"u",ｕ:"u",ù:"u",ú:"u",û:"u",ũ:"u",ṹ:"u",ū:"u",ṻ:"u",ŭ:"u",ü:"u",ǜ:"u",ǘ:"u",ǖ:"u",ǚ:"u",ủ:"u",ů:"u",ű:"u",ǔ:"u",ȕ:"u",ȗ:"u",ư:"u",ừ:"u",ứ:"u",ữ:"u",ử:"u",ự:"u",ụ:"u",ṳ:"u",ų:"u",ṷ:"u",ṵ:"u",ʉ:"u","ⓥ":"v",ｖ:"v",ṽ:"v",ṿ:"v",ʋ:"v",ꝟ:"v",ʌ:"v",ꝡ:"vy","ⓦ":"w",ｗ:"w",ẁ:"w",ẃ:"w",ŵ:"w",ẇ:"w",ẅ:"w",ẘ:"w",ẉ:"w",ⱳ:"w","ⓧ":"x",ｘ:"x",ẋ:"x",ẍ:"x","ⓨ":"y",ｙ:"y",ỳ:"y",ý:"y",ŷ:"y",ỹ:"y",ȳ:"y",ẏ:"y",ÿ:"y",ỷ:"y",ẙ:"y",ỵ:"y",ƴ:"y",ɏ:"y",ỿ:"y","ⓩ":"z",ｚ:"z",ź:"z",ẑ:"z",ż:"z",ž:"z",ẓ:"z",ẕ:"z",ƶ:"z",ȥ:"z",ɀ:"z",ⱬ:"z",ꝣ:"z",Ά:"Α",Έ:"Ε",Ή:"Η",Ί:"Ι",Ϊ:"Ι",Ό:"Ο",Ύ:"Υ",Ϋ:"Υ",Ώ:"Ω",ά:"α",έ:"ε",ή:"η",ί:"ι",ϊ:"ι",ΐ:"ι",ό:"ο",ύ:"υ",ϋ:"υ",ΰ:"υ",ώ:"ω",ς:"σ","’":"'"}})),t.define("select2/data/base",["../utils"],(function(e){function t(e,n){t.__super__.constructor.call(this)}return e.Extend(t,e.Observable),t.prototype.current=function(e){throw new Error("The `current` method must be defined in child classes.")},t.prototype.query=function(e,t){throw new Error("The `query` method must be defined in child classes.")},t.prototype.bind=function(e,t){},t.prototype.destroy=function(){},t.prototype.generateResultId=function(t,n){var o=t.id+"-result-";return o+=e.generateChars(4),null!=n.id?o+="-"+n.id.toString():o+="-"+e.generateChars(4),o},t})),t.define("select2/data/select",["./base","../utils","jquery"],(function(e,t,n){function o(e,t){this.$element=e,this.options=t,o.__super__.constructor.call(this)}return t.Extend(o,e),o.prototype.current=function(e){var t=[],o=this;this.$element.find(":selected").each((function(){var e=n(this),i=o.item(e);t.push(i)})),e(t)},o.prototype.select=function(e){var t=this;if(e.selected=!0,n(e.element).is("option"))return e.element.selected=!0,void this.$element.trigger("input").trigger("change");if(this.$element.prop("multiple"))this.current((function(o){var i=[];(e=[e]).push.apply(e,o);for(var r=0;r<e.length;r++){var s=e[r].id;-1===n.inArray(s,i)&&i.push(s)}t.$element.val(i),t.$element.trigger("input").trigger("change")}));else{var o=e.id;this.$element.val(o),this.$element.trigger("input").trigger("change")}},o.prototype.unselect=function(e){var t=this;if(this.$element.prop("multiple")){if(e.selected=!1,n(e.element).is("option"))return e.element.selected=!1,void this.$element.trigger("input").trigger("change");this.current((function(o){for(var i=[],r=0;r<o.length;r++){var s=o[r].id;s!==e.id&&-1===n.inArray(s,i)&&i.push(s)}t.$element.val(i),t.$element.trigger("input").trigger("change")}))}},o.prototype.bind=function(e,t){var n=this;this.container=e,e.on("select",(function(e){n.select(e.data)})),e.on("unselect",(function(e){n.unselect(e.data)}))},o.prototype.destroy=function(){this.$element.find("*").each((function(){t.RemoveData(this)}))},o.prototype.query=function(e,t){var o=[],i=this;this.$element.children().each((function(){var t=n(this);if(t.is("option")||t.is("optgroup")){var r=i.item(t),s=i.matches(e,r);null!==s&&o.push(s)}})),t({results:o})},o.prototype.addOptions=function(e){t.appendMany(this.$element,e)},o.prototype.option=function(e){var o;e.children?(o=document.createElement("optgroup")).label=e.text:void 0!==(o=document.createElement("option")).textContent?o.textContent=e.text:o.innerText=e.text,void 0!==e.id&&(o.value=e.id),e.disabled&&(o.disabled=!0),e.selected&&(o.selected=!0),e.title&&(o.title=e.title);var i=n(o),r=this._normalizeItem(e);return r.element=o,t.StoreData(o,"data",r),i},o.prototype.item=function(e){var o={};if(null!=(o=t.GetData(e[0],"data")))return o;if(e.is("option"))o={id:e.val(),text:e.text(),disabled:e.prop("disabled"),selected:e.prop("selected"),title:e.prop("title")};else if(e.is("optgroup")){o={text:e.prop("label"),children:[],title:e.prop("title")};for(var i=e.children("option"),r=[],s=0;s<i.length;s++){var a=n(i[s]),l=this.item(a);r.push(l)}o.children=r}return(o=this._normalizeItem(o)).element=e[0],t.StoreData(e[0],"data",o),o},o.prototype._normalizeItem=function(e){e!==Object(e)&&(e={id:e,text:e});var t={selected:!1,disabled:!1};return null!=(e=n.extend({},{text:""},e)).id&&(e.id=e.id.toString()),null!=e.text&&(e.text=e.text.toString()),null==e._resultId&&e.id&&null!=this.container&&(e._resultId=this.generateResultId(this.container,e)),n.extend({},t,e)},o.prototype.matches=function(e,t){return this.options.get("matcher")(e,t)},o})),t.define("select2/data/array",["./select","../utils","jquery"],(function(e,t,n){function o(e,t){this._dataToConvert=t.get("data")||[],o.__super__.constructor.call(this,e,t)}return t.Extend(o,e),o.prototype.bind=function(e,t){o.__super__.bind.call(this,e,t),this.addOptions(this.convertToOptions(this._dataToConvert))},o.prototype.select=function(e){var t=this.$element.find("option").filter((function(t,n){return n.value==e.id.toString()}));0===t.length&&(t=this.option(e),this.addOptions(t)),o.__super__.select.call(this,e)},o.prototype.convertToOptions=function(e){var o=this,i=this.$element.find("option"),r=i.map((function(){return o.item(n(this)).id})).get(),s=[];function a(e){return function(){return n(this).val()==e.id}}for(var l=0;l<e.length;l++){var c=this._normalizeItem(e[l]);if(n.inArray(c.id,r)>=0){var d=i.filter(a(c)),u=this.item(d),p=n.extend(!0,{},c,u),h=this.option(p);d.replaceWith(h)}else{var f=this.option(c);if(c.children){var m=this.convertToOptions(c.children);t.appendMany(f,m)}s.push(f)}}return s},o})),t.define("select2/data/ajax",["./array","../utils","jquery"],(function(e,t,n){function o(e,t){this.ajaxOptions=this._applyDefaults(t.get("ajax")),null!=this.ajaxOptions.processResults&&(this.processResults=this.ajaxOptions.processResults),o.__super__.constructor.call(this,e,t)}return t.Extend(o,e),o.prototype._applyDefaults=function(e){var t={data:function(e){return n.extend({},e,{q:e.term})},transport:function(e,t,o){var i=n.ajax(e);return i.then(t),i.fail(o),i}};return n.extend({},t,e,!0)},o.prototype.processResults=function(e){return e},o.prototype.query=function(e,t){var o=this;null!=this._request&&(n.isFunction(this._request.abort)&&this._request.abort(),this._request=null);var i=n.extend({type:"GET"},this.ajaxOptions);function r(){var r=i.transport(i,(function(i){var r=o.processResults(i,e);o.options.get("debug")&&window.console&&console.error&&(r&&r.results&&n.isArray(r.results)||console.error("Select2: The AJAX results did not return an array in the `results` key of the response.")),t(r)}),(function(){(!("status"in r)||0!==r.status&&"0"!==r.status)&&o.trigger("results:message",{message:"errorLoading"})}));o._request=r}"function"==typeof i.url&&(i.url=i.url.call(this.$element,e)),"function"==typeof i.data&&(i.data=i.data.call(this.$element,e)),this.ajaxOptions.delay&&null!=e.term?(this._queryTimeout&&window.clearTimeout(this._queryTimeout),this._queryTimeout=window.setTimeout(r,this.ajaxOptions.delay)):r()},o})),t.define("select2/data/tags",["jquery"],(function(e){function t(t,n,o){var i=o.get("tags"),r=o.get("createTag");void 0!==r&&(this.createTag=r);var s=o.get("insertTag");if(void 0!==s&&(this.insertTag=s),t.call(this,n,o),e.isArray(i))for(var a=0;a<i.length;a++){var l=i[a],c=this._normalizeItem(l),d=this.option(c);this.$element.append(d)}}return t.prototype.query=function(e,t,n){var o=this;function i(e,r){for(var s=e.results,a=0;a<s.length;a++){var l=s[a],c=null!=l.children&&!i({results:l.children},!0);if((l.text||"").toUpperCase()===(t.term||"").toUpperCase()||c)return!r&&(e.data=s,void n(e))}if(r)return!0;var d=o.createTag(t);if(null!=d){var u=o.option(d);u.attr("data-select2-tag",!0),o.addOptions([u]),o.insertTag(s,d)}e.results=s,n(e)}this._removeOldTags(),null!=t.term&&null==t.page?e.call(this,t,i):e.call(this,t,n)},t.prototype.createTag=function(t,n){var o=e.trim(n.term);return""===o?null:{id:o,text:o}},t.prototype.insertTag=function(e,t,n){t.unshift(n)},t.prototype._removeOldTags=function(t){this.$element.find("option[data-select2-tag]").each((function(){this.selected||e(this).remove()}))},t})),t.define("select2/data/tokenizer",["jquery"],(function(e){function t(e,t,n){var o=n.get("tokenizer");void 0!==o&&(this.tokenizer=o),e.call(this,t,n)}return t.prototype.bind=function(e,t,n){e.call(this,t,n),this.$search=t.dropdown.$search||t.selection.$search||n.find(".select2-search__field")},t.prototype.query=function(t,n,o){var i=this;function r(t){var n=i._normalizeItem(t);if(!i.$element.find("option").filter((function(){return e(this).val()===n.id})).length){var o=i.option(n);o.attr("data-select2-tag",!0),i._removeOldTags(),i.addOptions([o])}s(n)}function s(e){i.trigger("select",{data:e})}n.term=n.term||"";var a=this.tokenizer(n,this.options,r);a.term!==n.term&&(this.$search.length&&(this.$search.val(a.term),this.$search.trigger("focus")),n.term=a.term),t.call(this,n,o)},t.prototype.tokenizer=function(t,n,o,i){for(var r=o.get("tokenSeparators")||[],s=n.term,a=0,l=this.createTag||function(e){return{id:e.term,text:e.term}};a<s.length;){var c=s[a];if(-1!==e.inArray(c,r)){var d=s.substr(0,a),u=l(e.extend({},n,{term:d}));null!=u?(i(u),s=s.substr(a+1)||"",a=0):a++}else a++}return{term:s}},t})),t.define("select2/data/minimumInputLength",[],(function(){function e(e,t,n){this.minimumInputLength=n.get("minimumInputLength"),e.call(this,t,n)}return e.prototype.query=function(e,t,n){t.term=t.term||"",t.term.length<this.minimumInputLength?this.trigger("results:message",{message:"inputTooShort",args:{minimum:this.minimumInputLength,input:t.term,params:t}}):e.call(this,t,n)},e})),t.define("select2/data/maximumInputLength",[],(function(){function e(e,t,n){this.maximumInputLength=n.get("maximumInputLength"),e.call(this,t,n)}return e.prototype.query=function(e,t,n){t.term=t.term||"",this.maximumInputLength>0&&t.term.length>this.maximumInputLength?this.trigger("results:message",{message:"inputTooLong",args:{maximum:this.maximumInputLength,input:t.term,params:t}}):e.call(this,t,n)},e})),t.define("select2/data/maximumSelectionLength",[],(function(){function e(e,t,n){this.maximumSelectionLength=n.get("maximumSelectionLength"),e.call(this,t,n)}return e.prototype.bind=function(e,t,n){var o=this;e.call(this,t,n),t.on("select",(function(){o._checkIfMaximumSelected()}))},e.prototype.query=function(e,t,n){var o=this;this._checkIfMaximumSelected((function(){e.call(o,t,n)}))},e.prototype._checkIfMaximumSelected=function(e,t){var n=this;this.current((function(e){var o=null!=e?e.length:0;n.maximumSelectionLength>0&&o>=n.maximumSelectionLength?n.trigger("results:message",{message:"maximumSelected",args:{maximum:n.maximumSelectionLength}}):t&&t()}))},e})),t.define("select2/dropdown",["jquery","./utils"],(function(e,t){function n(e,t){this.$element=e,this.options=t,n.__super__.constructor.call(this)}return t.Extend(n,t.Observable),n.prototype.render=function(){var t=e('<span class="select2-dropdown"><span class="select2-results"></span></span>');return t.attr("dir",this.options.get("dir")),this.$dropdown=t,t},n.prototype.bind=function(){},n.prototype.position=function(e,t){},n.prototype.destroy=function(){this.$dropdown.remove()},n})),t.define("select2/dropdown/search",["jquery","../utils"],(function(e,t){function n(){}return n.prototype.render=function(t){var n=t.call(this),o=e('<span class="select2-search select2-search--dropdown"><input class="select2-search__field" type="search" tabindex="-1" autocomplete="off" autocorrect="off" autocapitalize="none" spellcheck="false" role="searchbox" aria-autocomplete="list" /></span>');return this.$searchContainer=o,this.$search=o.find("input"),n.prepend(o),n},n.prototype.bind=function(t,n,o){var i=this,r=n.id+"-results";t.call(this,n,o),this.$search.on("keydown",(function(e){i.trigger("keypress",e),i._keyUpPrevented=e.isDefaultPrevented()})),this.$search.on("input",(function(t){e(this).off("keyup")})),this.$search.on("keyup input",(function(e){i.handleSearch(e)})),n.on("open",(function(){i.$search.attr("tabindex",0),i.$search.attr("aria-controls",r),i.$search.trigger("focus"),window.setTimeout((function(){i.$search.trigger("focus")}),0)})),n.on("close",(function(){i.$search.attr("tabindex",-1),i.$search.removeAttr("aria-controls"),i.$search.removeAttr("aria-activedescendant"),i.$search.val(""),i.$search.trigger("blur")})),n.on("focus",(function(){n.isOpen()||i.$search.trigger("focus")})),n.on("results:all",(function(e){null!=e.query.term&&""!==e.query.term||(i.showSearch(e)?i.$searchContainer.removeClass("select2-search--hide"):i.$searchContainer.addClass("select2-search--hide"))})),n.on("results:focus",(function(e){e.data._resultId?i.$search.attr("aria-activedescendant",e.data._resultId):i.$search.removeAttr("aria-activedescendant")}))},n.prototype.handleSearch=function(e){if(!this._keyUpPrevented){var t=this.$search.val();this.trigger("query",{term:t})}this._keyUpPrevented=!1},n.prototype.showSearch=function(e,t){return!0},n})),t.define("select2/dropdown/hidePlaceholder",[],(function(){function e(e,t,n,o){this.placeholder=this.normalizePlaceholder(n.get("placeholder")),e.call(this,t,n,o)}return e.prototype.append=function(e,t){t.results=this.removePlaceholder(t.results),e.call(this,t)},e.prototype.normalizePlaceholder=function(e,t){return"string"==typeof t&&(t={id:"",text:t}),t},e.prototype.removePlaceholder=function(e,t){for(var n=t.slice(0),o=t.length-1;o>=0;o--){var i=t[o];this.placeholder.id===i.id&&n.splice(o,1)}return n},e})),t.define("select2/dropdown/infiniteScroll",["jquery"],(function(e){function t(e,t,n,o){this.lastParams={},e.call(this,t,n,o),this.$loadingMore=this.createLoadingMore(),this.loading=!1}return t.prototype.append=function(e,t){this.$loadingMore.remove(),this.loading=!1,e.call(this,t),this.showLoadingMore(t)&&(this.$results.append(this.$loadingMore),this.loadMoreIfNeeded())},t.prototype.bind=function(e,t,n){var o=this;e.call(this,t,n),t.on("query",(function(e){o.lastParams=e,o.loading=!0})),t.on("query:append",(function(e){o.lastParams=e,o.loading=!0})),this.$results.on("scroll",this.loadMoreIfNeeded.bind(this))},t.prototype.loadMoreIfNeeded=function(){var t=e.contains(document.documentElement,this.$loadingMore[0]);!this.loading&&t&&this.$results.offset().top+this.$results.outerHeight(!1)+50>=this.$loadingMore.offset().top+this.$loadingMore.outerHeight(!1)&&this.loadMore()},t.prototype.loadMore=function(){this.loading=!0;var t=e.extend({},{page:1},this.lastParams);t.page++,this.trigger("query:append",t)},t.prototype.showLoadingMore=function(e,t){return t.pagination&&t.pagination.more},t.prototype.createLoadingMore=function(){var t=e('<li class="select2-results__option select2-results__option--load-more"role="option" aria-disabled="true"></li>'),n=this.options.get("translations").get("loadingMore");return t.html(n(this.lastParams)),t},t})),t.define("select2/dropdown/attachBody",["jquery","../utils"],(function(e,t){function n(t,n,o){this.$dropdownParent=e(o.get("dropdownParent")||document.body),t.call(this,n,o)}return n.prototype.bind=function(e,t,n){var o=this;e.call(this,t,n),t.on("open",(function(){o._showDropdown(),o._attachPositioningHandler(t),o._bindContainerResultHandlers(t)})),t.on("close",(function(){o._hideDropdown(),o._detachPositioningHandler(t)})),this.$dropdownContainer.on("mousedown",(function(e){e.stopPropagation()}))},n.prototype.destroy=function(e){e.call(this),this.$dropdownContainer.remove()},n.prototype.position=function(e,t,n){t.attr("class",n.attr("class")),t.removeClass("select2"),t.addClass("select2-container--open"),t.css({position:"absolute",top:-999999}),this.$container=n},n.prototype.render=function(t){var n=e("<span></span>"),o=t.call(this);return n.append(o),this.$dropdownContainer=n,n},n.prototype._hideDropdown=function(e){this.$dropdownContainer.detach()},n.prototype._bindContainerResultHandlers=function(e,t){if(!this._containerResultsHandlersBound){var n=this;t.on("results:all",(function(){n._positionDropdown(),n._resizeDropdown()})),t.on("results:append",(function(){n._positionDropdown(),n._resizeDropdown()})),t.on("results:message",(function(){n._positionDropdown(),n._resizeDropdown()})),t.on("select",(function(){n._positionDropdown(),n._resizeDropdown()})),t.on("unselect",(function(){n._positionDropdown(),n._resizeDropdown()})),this._containerResultsHandlersBound=!0}},n.prototype._attachPositioningHandler=function(n,o){var i=this,r="scroll.select2."+o.id,s="resize.select2."+o.id,a="orientationchange.select2."+o.id,l=this.$container.parents().filter(t.hasScroll);l.each((function(){t.StoreData(this,"select2-scroll-position",{x:e(this).scrollLeft(),y:e(this).scrollTop()})})),l.on(r,(function(n){var o=t.GetData(this,"select2-scroll-position");e(this).scrollTop(o.y)})),e(window).on(r+" "+s+" "+a,(function(e){i._positionDropdown(),i._resizeDropdown()}))},n.prototype._detachPositioningHandler=function(n,o){var i="scroll.select2."+o.id,r="resize.select2."+o.id,s="orientationchange.select2."+o.id;this.$container.parents().filter(t.hasScroll).off(i),e(window).off(i+" "+r+" "+s)},n.prototype._positionDropdown=function(){var t=e(window),n=this.$dropdown.hasClass("select2-dropdown--above"),o=this.$dropdown.hasClass("select2-dropdown--below"),i=null,r=this.$container.offset();r.bottom=r.top+this.$container.outerHeight(!1);var s={height:this.$container.outerHeight(!1)};s.top=r.top,s.bottom=r.top+s.height;var a={height:this.$dropdown.outerHeight(!1)},l={top:t.scrollTop(),bottom:t.scrollTop()+t.height()},c=l.top<r.top-a.height,d=l.bottom>r.bottom+a.height,u={left:r.left,top:s.bottom},p=this.$dropdownParent;"static"===p.css("position")&&(p=p.offsetParent());var h={top:0,left:0};(e.contains(document.body,p[0])||p[0].isConnected)&&(h=p.offset()),u.top-=h.top,u.left-=h.left,n||o||(i="below"),d||!c||n?!c&&d&&n&&(i="below"):i="above",("above"==i||n&&"below"!==i)&&(u.top=s.top-h.top-a.height),null!=i&&(this.$dropdown.removeClass("select2-dropdown--below select2-dropdown--above").addClass("select2-dropdown--"+i),this.$container.removeClass("select2-container--below select2-container--above").addClass("select2-container--"+i)),this.$dropdownContainer.css(u)},n.prototype._resizeDropdown=function(){var e={width:this.$container.outerWidth(!1)+"px"};this.options.get("dropdownAutoWidth")&&(e.minWidth=e.width,e.position="relative",e.width="auto"),this.$dropdown.css(e)},n.prototype._showDropdown=function(e){this.$dropdownContainer.appendTo(this.$dropdownParent),this._positionDropdown(),this._resizeDropdown()},n})),t.define("select2/dropdown/minimumResultsForSearch",[],(function(){function e(t){for(var n=0,o=0;o<t.length;o++){var i=t[o];i.children?n+=e(i.children):n++}return n}function t(e,t,n,o){this.minimumResultsForSearch=n.get("minimumResultsForSearch"),this.minimumResultsForSearch<0&&(this.minimumResultsForSearch=1/0),e.call(this,t,n,o)}return t.prototype.showSearch=function(t,n){return!(e(n.data.results)<this.minimumResultsForSearch)&&t.call(this,n)},t})),t.define("select2/dropdown/selectOnClose",["../utils"],(function(e){function t(){}return t.prototype.bind=function(e,t,n){var o=this;e.call(this,t,n),t.on("close",(function(e){o._handleSelectOnClose(e)}))},t.prototype._handleSelectOnClose=function(t,n){if(n&&null!=n.originalSelect2Event){var o=n.originalSelect2Event;if("select"===o._type||"unselect"===o._type)return}var i=this.getHighlightedResults();if(!(i.length<1)){var r=e.GetData(i[0],"data");null!=r.element&&r.element.selected||null==r.element&&r.selected||this.trigger("select",{data:r})}},t})),t.define("select2/dropdown/closeOnSelect",[],(function(){function e(){}return e.prototype.bind=function(e,t,n){var o=this;e.call(this,t,n),t.on("select",(function(e){o._selectTriggered(e)})),t.on("unselect",(function(e){o._selectTriggered(e)}))},e.prototype._selectTriggered=function(e,t){var n=t.originalEvent;n&&(n.ctrlKey||n.metaKey)||this.trigger("close",{originalEvent:n,originalSelect2Event:t})},e})),t.define("select2/i18n/en",[],(function(){return{errorLoading:function(){return"The results could not be loaded."},inputTooLong:function(e){var t=e.input.length-e.maximum,n="Please delete "+t+" character";return 1!=t&&(n+="s"),n},inputTooShort:function(e){return"Please enter "+(e.minimum-e.input.length)+" or more characters"},loadingMore:function(){return"Loading more results…"},maximumSelected:function(e){var t="You can only select "+e.maximum+" item";return 1!=e.maximum&&(t+="s"),t},noResults:function(){return"No results found"},searching:function(){return"Searching…"},removeAllItems:function(){return"Remove all items"}}})),t.define("select2/defaults",["jquery","require","./results","./selection/single","./selection/multiple","./selection/placeholder","./selection/allowClear","./selection/search","./selection/eventRelay","./utils","./translation","./diacritics","./data/select","./data/array","./data/ajax","./data/tags","./data/tokenizer","./data/minimumInputLength","./data/maximumInputLength","./data/maximumSelectionLength","./dropdown","./dropdown/search","./dropdown/hidePlaceholder","./dropdown/infiniteScroll","./dropdown/attachBody","./dropdown/minimumResultsForSearch","./dropdown/selectOnClose","./dropdown/closeOnSelect","./i18n/en"],(function(e,t,n,o,i,r,s,a,l,c,d,u,p,h,f,m,g,v,_,y,b,w,x,A,C,$,O,S,E){function k(){this.reset()}return k.prototype.apply=function(d){if(null==(d=e.extend(!0,{},this.defaults,d)).dataAdapter){if(null!=d.ajax?d.dataAdapter=f:null!=d.data?d.dataAdapter=h:d.dataAdapter=p,d.minimumInputLength>0&&(d.dataAdapter=c.Decorate(d.dataAdapter,v)),d.maximumInputLength>0&&(d.dataAdapter=c.Decorate(d.dataAdapter,_)),d.maximumSelectionLength>0&&(d.dataAdapter=c.Decorate(d.dataAdapter,y)),d.tags&&(d.dataAdapter=c.Decorate(d.dataAdapter,m)),null==d.tokenSeparators&&null==d.tokenizer||(d.dataAdapter=c.Decorate(d.dataAdapter,g)),null!=d.query){var u=t(d.amdBase+"compat/query");d.dataAdapter=c.Decorate(d.dataAdapter,u)}if(null!=d.initSelection){var E=t(d.amdBase+"compat/initSelection");d.dataAdapter=c.Decorate(d.dataAdapter,E)}}if(null==d.resultsAdapter&&(d.resultsAdapter=n,null!=d.ajax&&(d.resultsAdapter=c.Decorate(d.resultsAdapter,A)),null!=d.placeholder&&(d.resultsAdapter=c.Decorate(d.resultsAdapter,x)),d.selectOnClose&&(d.resultsAdapter=c.Decorate(d.resultsAdapter,O))),null==d.dropdownAdapter){if(d.multiple)d.dropdownAdapter=b;else{var k=c.Decorate(b,w);d.dropdownAdapter=k}if(0!==d.minimumResultsForSearch&&(d.dropdownAdapter=c.Decorate(d.dropdownAdapter,$)),d.closeOnSelect&&(d.dropdownAdapter=c.Decorate(d.dropdownAdapter,S)),null!=d.dropdownCssClass||null!=d.dropdownCss||null!=d.adaptDropdownCssClass){var D=t(d.amdBase+"compat/dropdownCss");d.dropdownAdapter=c.Decorate(d.dropdownAdapter,D)}d.dropdownAdapter=c.Decorate(d.dropdownAdapter,C)}if(null==d.selectionAdapter){if(d.multiple?d.selectionAdapter=i:d.selectionAdapter=o,null!=d.placeholder&&(d.selectionAdapter=c.Decorate(d.selectionAdapter,r)),d.allowClear&&(d.selectionAdapter=c.Decorate(d.selectionAdapter,s)),d.multiple&&(d.selectionAdapter=c.Decorate(d.selectionAdapter,a)),null!=d.containerCssClass||null!=d.containerCss||null!=d.adaptContainerCssClass){var L=t(d.amdBase+"compat/containerCss");d.selectionAdapter=c.Decorate(d.selectionAdapter,L)}d.selectionAdapter=c.Decorate(d.selectionAdapter,l)}d.language=this._resolveLanguage(d.language),d.language.push("en");for(var P=[],T=0;T<d.language.length;T++){var j=d.language[T];-1===P.indexOf(j)&&P.push(j)}return d.language=P,d.translations=this._processTranslations(d.language,d.debug),d},k.prototype.reset=function(){function t(e){function t(e){return u[e]||e}return e.replace(/[^\u0000-\u007E]/g,t)}function n(o,i){if(""===e.trim(o.term))return i;if(i.children&&i.children.length>0){for(var r=e.extend(!0,{},i),s=i.children.length-1;s>=0;s--)null==n(o,i.children[s])&&r.children.splice(s,1);return r.children.length>0?r:n(o,r)}var a=t(i.text).toUpperCase(),l=t(o.term).toUpperCase();return a.indexOf(l)>-1?i:null}this.defaults={amdBase:"./",amdLanguageBase:"./i18n/",closeOnSelect:!0,debug:!1,dropdownAutoWidth:!1,escapeMarkup:c.escapeMarkup,language:{},matcher:n,minimumInputLength:0,maximumInputLength:0,maximumSelectionLength:0,minimumResultsForSearch:0,selectOnClose:!1,scrollAfterSelect:!1,sorter:function(e){return e},templateResult:function(e){return e.text},templateSelection:function(e){return e.text},theme:"default",width:"resolve"}},k.prototype.applyFromElement=function(e,t){var n=e.language,o=this.defaults.language,i=t.prop("lang"),r=t.closest("[lang]").prop("lang"),s=Array.prototype.concat.call(this._resolveLanguage(i),this._resolveLanguage(n),this._resolveLanguage(o),this._resolveLanguage(r));return e.language=s,e},k.prototype._resolveLanguage=function(t){if(!t)return[];if(e.isEmptyObject(t))return[];if(e.isPlainObject(t))return[t];var n;n=e.isArray(t)?t:[t];for(var o=[],i=0;i<n.length;i++)if(o.push(n[i]),"string"==typeof n[i]&&n[i].indexOf("-")>0){var r=n[i].split("-")[0];o.push(r)}return o},k.prototype._processTranslations=function(t,n){for(var o=new d,i=0;i<t.length;i++){var r=new d,s=t[i];if("string"==typeof s)try{r=d.loadPath(s)}catch(e){try{s=this.defaults.amdLanguageBase+s,r=d.loadPath(s)}catch(e){n&&window.console&&console.warn&&console.warn('Select2: The language file for "'+s+'" could not be automatically loaded. A fallback will be used instead.')}}else r=e.isPlainObject(s)?new d(s):s;o.extend(r)}return o},k.prototype.set=function(t,n){var o={};o[e.camelCase(t)]=n;var i=c._convertData(o);e.extend(!0,this.defaults,i)},new k})),t.define("select2/options",["require","jquery","./defaults","./utils"],(function(e,t,n,o){function i(t,i){if(this.options=t,null!=i&&this.fromElement(i),null!=i&&(this.options=n.applyFromElement(this.options,i)),this.options=n.apply(this.options),i&&i.is("input")){var r=e(this.get("amdBase")+"compat/inputData");this.options.dataAdapter=o.Decorate(this.options.dataAdapter,r)}}return i.prototype.fromElement=function(e){var n=["select2"];null==this.options.multiple&&(this.options.multiple=e.prop("multiple")),null==this.options.disabled&&(this.options.disabled=e.prop("disabled")),null==this.options.dir&&(e.prop("dir")?this.options.dir=e.prop("dir"):e.closest("[dir]").prop("dir")?this.options.dir=e.closest("[dir]").prop("dir"):this.options.dir="ltr"),e.prop("disabled",this.options.disabled),e.prop("multiple",this.options.multiple),o.GetData(e[0],"select2Tags")&&(this.options.debug&&window.console&&console.warn&&console.warn('Select2: The `data-select2-tags` attribute has been changed to use the `data-data` and `data-tags="true"` attributes and will be removed in future versions of Select2.'),o.StoreData(e[0],"data",o.GetData(e[0],"select2Tags")),o.StoreData(e[0],"tags",!0)),o.GetData(e[0],"ajaxUrl")&&(this.options.debug&&window.console&&console.warn&&console.warn("Select2: The `data-ajax-url` attribute has been changed to `data-ajax--url` and support for the old attribute will be removed in future versions of Select2."),e.attr("ajax--url",o.GetData(e[0],"ajaxUrl")),o.StoreData(e[0],"ajax-Url",o.GetData(e[0],"ajaxUrl")));var i={};function r(e,t){return t.toUpperCase()}for(var s=0;s<e[0].attributes.length;s++){var a=e[0].attributes[s].name,l="data-";if(a.substr(0,l.length)==l){var c=a.substring(l.length),d=o.GetData(e[0],c);i[c.replace(/-([a-z])/g,r)]=d}}t.fn.jquery&&"1."==t.fn.jquery.substr(0,2)&&e[0].dataset&&(i=t.extend(!0,{},e[0].dataset,i));var u=t.extend(!0,{},o.GetData(e[0]),i);for(var p in u=o._convertData(u))t.inArray(p,n)>-1||(t.isPlainObject(this.options[p])?t.extend(this.options[p],u[p]):this.options[p]=u[p]);return this},i.prototype.get=function(e){return this.options[e]},i.prototype.set=function(e,t){this.options[e]=t},i})),t.define("select2/core",["jquery","./options","./utils","./keys"],(function(e,t,n,o){var i=function(e,o){null!=n.GetData(e[0],"select2")&&n.GetData(e[0],"select2").destroy(),this.$element=e,this.id=this._generateId(e),o=o||{},this.options=new t(o,e),i.__super__.constructor.call(this);var r=e.attr("tabindex")||0;n.StoreData(e[0],"old-tabindex",r),e.attr("tabindex","-1");var s=this.options.get("dataAdapter");this.dataAdapter=new s(e,this.options);var a=this.render();this._placeContainer(a);var l=this.options.get("selectionAdapter");this.selection=new l(e,this.options),this.$selection=this.selection.render(),this.selection.position(this.$selection,a);var c=this.options.get("dropdownAdapter");this.dropdown=new c(e,this.options),this.$dropdown=this.dropdown.render(),this.dropdown.position(this.$dropdown,a);var d=this.options.get("resultsAdapter");this.results=new d(e,this.options,this.dataAdapter),this.$results=this.results.render(),this.results.position(this.$results,this.$dropdown);var u=this;this._bindAdapters(),this._registerDomEvents(),this._registerDataEvents(),this._registerSelectionEvents(),this._registerDropdownEvents(),this._registerResultsEvents(),this._registerEvents(),this.dataAdapter.current((function(e){u.trigger("selection:update",{data:e})})),e.addClass("select2-hidden-accessible"),e.attr("aria-hidden","true"),this._syncAttributes(),n.StoreData(e[0],"select2",this),e.data("select2",this)};return n.Extend(i,n.Observable),i.prototype._generateId=function(e){return"select2-"+(null!=e.attr("id")?e.attr("id"):null!=e.attr("name")?e.attr("name")+"-"+n.generateChars(2):n.generateChars(4)).replace(/(:|\.|\[|\]|,)/g,"")},i.prototype._placeContainer=function(e){e.insertAfter(this.$element);var t=this._resolveWidth(this.$element,this.options.get("width"));null!=t&&e.css("width",t)},i.prototype._resolveWidth=function(e,t){var n=/^width:(([-+]?([0-9]*\.)?[0-9]+)(px|em|ex|%|in|cm|mm|pt|pc))/i;if("resolve"==t){var o=this._resolveWidth(e,"style");return null!=o?o:this._resolveWidth(e,"element")}if("element"==t){var i=e.outerWidth(!1);return i<=0?"auto":i+"px"}if("style"==t){var r=e.attr("style");if("string"!=typeof r)return null;for(var s=r.split(";"),a=0,l=s.length;a<l;a+=1){var c=s[a].replace(/\s/g,"").match(n);if(null!==c&&c.length>=1)return c[1]}return null}return"computedstyle"==t?window.getComputedStyle(e[0]).width:t},i.prototype._bindAdapters=function(){this.dataAdapter.bind(this,this.$container),this.selection.bind(this,this.$container),this.dropdown.bind(this,this.$container),this.results.bind(this,this.$container)},i.prototype._registerDomEvents=function(){var e=this;this.$element.on("change.select2",(function(){e.dataAdapter.current((function(t){e.trigger("selection:update",{data:t})}))})),this.$element.on("focus.select2",(function(t){e.trigger("focus",t)})),this._syncA=n.bind(this._syncAttributes,this),this._syncS=n.bind(this._syncSubtree,this),this.$element[0].attachEvent&&this.$element[0].attachEvent("onpropertychange",this._syncA);var t=window.MutationObserver||window.WebKitMutationObserver||window.MozMutationObserver;null!=t?(this._observer=new t((function(t){e._syncA(),e._syncS(null,t)})),this._observer.observe(this.$element[0],{attributes:!0,childList:!0,subtree:!1})):this.$element[0].addEventListener&&(this.$element[0].addEventListener("DOMAttrModified",e._syncA,!1),this.$element[0].addEventListener("DOMNodeInserted",e._syncS,!1),this.$element[0].addEventListener("DOMNodeRemoved",e._syncS,!1))},i.prototype._registerDataEvents=function(){var e=this;this.dataAdapter.on("*",(function(t,n){e.trigger(t,n)}))},i.prototype._registerSelectionEvents=function(){var t=this,n=["toggle","focus"];this.selection.on("toggle",(function(){t.toggleDropdown()})),this.selection.on("focus",(function(e){t.focus(e)})),this.selection.on("*",(function(o,i){-1===e.inArray(o,n)&&t.trigger(o,i)}))},i.prototype._registerDropdownEvents=function(){var e=this;this.dropdown.on("*",(function(t,n){e.trigger(t,n)}))},i.prototype._registerResultsEvents=function(){var e=this;this.results.on("*",(function(t,n){e.trigger(t,n)}))},i.prototype._registerEvents=function(){var e=this;this.on("open",(function(){e.$container.addClass("select2-container--open")})),this.on("close",(function(){e.$container.removeClass("select2-container--open")})),this.on("enable",(function(){e.$container.removeClass("select2-container--disabled")})),this.on("disable",(function(){e.$container.addClass("select2-container--disabled")})),this.on("blur",(function(){e.$container.removeClass("select2-container--focus")})),this.on("query",(function(t){e.isOpen()||e.trigger("open",{}),this.dataAdapter.query(t,(function(n){e.trigger("results:all",{data:n,query:t})}))})),this.on("query:append",(function(t){this.dataAdapter.query(t,(function(n){e.trigger("results:append",{data:n,query:t})}))})),this.on("keypress",(function(t){var n=t.which;e.isOpen()?n===o.ESC||n===o.TAB||n===o.UP&&t.altKey?(e.close(t),t.preventDefault()):n===o.ENTER?(e.trigger("results:select",{}),t.preventDefault()):n===o.SPACE&&t.ctrlKey?(e.trigger("results:toggle",{}),t.preventDefault()):n===o.UP?(e.trigger("results:previous",{}),t.preventDefault()):n===o.DOWN&&(e.trigger("results:next",{}),t.preventDefault()):(n===o.ENTER||n===o.SPACE||n===o.DOWN&&t.altKey)&&(e.open(),t.preventDefault())}))},i.prototype._syncAttributes=function(){this.options.set("disabled",this.$element.prop("disabled")),this.isDisabled()?(this.isOpen()&&this.close(),this.trigger("disable",{})):this.trigger("enable",{})},i.prototype._isChangeMutation=function(t,n){var o=!1,i=this;if(!t||!t.target||"OPTION"===t.target.nodeName||"OPTGROUP"===t.target.nodeName){if(n)if(n.addedNodes&&n.addedNodes.length>0)for(var r=0;r<n.addedNodes.length;r++)n.addedNodes[r].selected&&(o=!0);else n.removedNodes&&n.removedNodes.length>0?o=!0:e.isArray(n)&&e.each(n,(function(e,t){if(i._isChangeMutation(e,t))return o=!0,!1}));else o=!0;return o}},i.prototype._syncSubtree=function(e,t){var n=this._isChangeMutation(e,t),o=this;n&&this.dataAdapter.current((function(e){o.trigger("selection:update",{data:e})}))},i.prototype.trigger=function(e,t){var n=i.__super__.trigger,o={open:"opening",close:"closing",select:"selecting",unselect:"unselecting",clear:"clearing"};if(void 0===t&&(t={}),e in o){var r=o[e],s={prevented:!1,name:e,args:t};if(n.call(this,r,s),s.prevented)return void(t.prevented=!0)}n.call(this,e,t)},i.prototype.toggleDropdown=function(){this.isDisabled()||(this.isOpen()?this.close():this.open())},i.prototype.open=function(){this.isOpen()||this.isDisabled()||this.trigger("query",{})},i.prototype.close=function(e){this.isOpen()&&this.trigger("close",{originalEvent:e})},i.prototype.isEnabled=function(){return!this.isDisabled()},i.prototype.isDisabled=function(){return this.options.get("disabled")},i.prototype.isOpen=function(){return this.$container.hasClass("select2-container--open")},i.prototype.hasFocus=function(){return this.$container.hasClass("select2-container--focus")},i.prototype.focus=function(e){this.hasFocus()||(this.$container.addClass("select2-container--focus"),this.trigger("focus",{}))},i.prototype.enable=function(e){this.options.get("debug")&&window.console&&console.warn&&console.warn('Select2: The `select2("enable")` method has been deprecated and will be removed in later Select2 versions. Use $element.prop("disabled") instead.'),null!=e&&0!==e.length||(e=[!0]);var t=!e[0];this.$element.prop("disabled",t)},i.prototype.data=function(){this.options.get("debug")&&arguments.length>0&&window.console&&console.warn&&console.warn('Select2: Data can no longer be set using `select2("data")`. You should consider setting the value instead using `$element.val()`.');var e=[];return this.dataAdapter.current((function(t){e=t})),e},i.prototype.val=function(t){if(this.options.get("debug")&&window.console&&console.warn&&console.warn('Select2: The `select2("val")` method has been deprecated and will be removed in later Select2 versions. Use $element.val() instead.'),null==t||0===t.length)return this.$element.val();var n=t[0];e.isArray(n)&&(n=e.map(n,(function(e){return e.toString()}))),this.$element.val(n).trigger("input").trigger("change")},i.prototype.destroy=function(){this.$container.remove(),this.$element[0].detachEvent&&this.$element[0].detachEvent("onpropertychange",this._syncA),null!=this._observer?(this._observer.disconnect(),this._observer=null):this.$element[0].removeEventListener&&(this.$element[0].removeEventListener("DOMAttrModified",this._syncA,!1),this.$element[0].removeEventListener("DOMNodeInserted",this._syncS,!1),this.$element[0].removeEventListener("DOMNodeRemoved",this._syncS,!1)),this._syncA=null,this._syncS=null,this.$element.off(".select2"),this.$element.attr("tabindex",n.GetData(this.$element[0],"old-tabindex")),this.$element.removeClass("select2-hidden-accessible"),this.$element.attr("aria-hidden","false"),n.RemoveData(this.$element[0]),this.$element.removeData("select2"),this.dataAdapter.destroy(),this.selection.destroy(),this.dropdown.destroy(),this.results.destroy(),this.dataAdapter=null,this.selection=null,this.dropdown=null,this.results=null},i.prototype.render=function(){var t=e('<span class="select2 select2-container"><span class="selection"></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>');return t.attr("dir",this.options.get("dir")),this.$container=t,this.$container.addClass("select2-container--"+this.options.get("theme")),n.StoreData(t[0],"element",this.$element),t},i})),t.define("jquery-mousewheel",["jquery"],(function(e){return e})),t.define("jquery.select2",["jquery","jquery-mousewheel","./select2/core","./select2/defaults","./select2/utils"],(function(e,t,n,o,i){if(null==e.fn.select2){var r=["open","close","destroy"];e.fn.select2=function(t){if("object"==typeof(t=t||{}))return this.each((function(){var o=e.extend(!0,{},t);new n(e(this),o)})),this;if("string"==typeof t){var o,s=Array.prototype.slice.call(arguments,1);return this.each((function(){var e=i.GetData(this,"select2");null==e&&window.console&&console.error&&console.error("The select2('"+t+"') method was called on an element that is not using Select2."),o=e[t].apply(e,s)})),e.inArray(t,r)>-1?this:o}throw new Error("Invalid arguments for Select2: "+t)}}return null==e.fn.select2.defaults&&(e.fn.select2.defaults=o),n})),{define:t.define,require:t.require}}(),n=t.require("jquery.select2");return e.fn.select2.amd=t,n})?o.apply(t,i):o)||(e.exports=r)},913:()=>{const e=document.querySelector('input[type="checkbox"][name="carousel_slider_allow_tracking"]');e&&(window.console.log(window.ajaxurl),e.addEventListener("change",(t=>{const n=new URL(window.CarouselSliderL10n.ajaxUrl);n.searchParams.set("action","carousel_slider_tracker_consent"),n.searchParams.set("_token",e.dataset.token),t.target.checked?n.searchParams.set("carousel_slider_tracker_optin","true"):n.searchParams.set("carousel_slider_tracker_optout","true"),window.console.log(n.toString()),(e=>new Promise((t=>{let n=new XMLHttpRequest;n.addEventListener("load",(()=>{n.readyState===XMLHttpRequest.DONE&&200===n.status&&t(n.responseText)})),n.open("GET",e),n.setRequestHeader("Accept","application/json"),n.send()})))(n.toString()).then((()=>{}))})))},926:()=>{class e extends HTMLElement{constructor(){super(),this.attachShadow({mode:"open"});const t=document.createElement("style");t.textContent=e.getStyle(),this.shadowRoot.append(t,this.getElement())}getElement(){const e=document.createElement("button");return e.classList.add("shapla-cross"),this.hasAttribute("size")&&e.classList.add(`is-${this.getAttribute("size")}`),e}attributeChangedCallback(e,t,n){const o=this.shadowRoot.querySelector("button");"size"===e&&this.hasAttribute("size")&&o.classList.add(`is-${this.getAttribute("size")}`)}static get observedAttributes(){return["size"]}static getStyle(){return'.shapla-cross {\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  background-color: var(--delete-icon-background, hsla(0, 0%, 4%, .2));\n  border: none;\n  border-radius: 290486px;\n  cursor: pointer;\n  display: inline-block;\n  flex-grow: 0;\n  flex-shrink: 0;\n  font-size: 0;\n  height: var(--delete-icon-size, 20px);\n  outline: none;\n  pointer-events: auto;\n  position: relative;\n  -webkit-user-select: none;\n  user-select: none;\n  vertical-align: top;\n  width: var(--delete-icon-size, 20px)\n}\n\n.shapla-cross:after, .shapla-cross:before {\n  background-color: var(--delete-icon-color, #fff);\n  content: "";\n  display: block;\n  left: 50%;\n  position: absolute;\n  top: 50%;\n  transform: translateX(-50%) translateY(-50%) rotate(45deg);\n  transform-origin: center center\n}\n\n.shapla-cross:before {\n  height: 2px;\n  width: 50%\n}\n\n.shapla-cross:after {\n  height: 50%;\n  width: 2px\n}\n\n.shapla-cross:focus, .shapla-cross:hover {\n  background-color: var(--delete-icon-background-dark, hsla(0, 0%, 4%, .3))\n}\n\n.shapla-cross:active {\n  box-shadow: 0 3px 4px 0 rgba(0, 0, 0, .14), 0 3px 3px -2px rgba(0, 0, 0, .2), 0 1px 8px 0 rgba(0, 0, 0, .12)\n}\n\n.shapla-cross.is-small {\n  --delete-icon-size: 16px\n}\n\n.shapla-cross.is-medium {\n  --delete-icon-size: 24px\n}\n\n.shapla-cross.is-large {\n  --delete-icon-size: 32px\n}\n\n.shapla-cross.is-error {\n  --delete-icon-background: var(--shapla-error, #dc3545);\n  --delete-icon-background-dark: var(--shapla-error-variant, #d32535);\n  --delete-icon-color: var(--shapla-on-error, #fff)\n}'}}customElements.define("shapla-cross",e)}},t={};function n(o){var i=t[o];if(void 0!==i)return i.exports;var r=t[o]={exports:{}};return e[o](r,r.exports,n),r.exports}n.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return n.d(t,{a:t}),t},n.d=(e,t)=>{for(var o in t)n.o(t,o)&&!n.o(e,o)&&Object.defineProperty(e,o,{enumerable:!0,get:t[o]})},n.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),(()=>{"use strict";var e=n(669),t=n.n(e);function o(e){if(null==e)return window;if("[object Window]"!==e.toString()){var t=e.ownerDocument;return t&&t.defaultView||window}return e}function i(e){return e instanceof o(e).Element||e instanceof Element}function r(e){return e instanceof o(e).HTMLElement||e instanceof HTMLElement}function s(e){return"undefined"!=typeof ShadowRoot&&(e instanceof o(e).ShadowRoot||e instanceof ShadowRoot)}var a=Math.max,l=Math.min,c=Math.round;function d(){var e=navigator.userAgentData;return null!=e&&e.brands&&Array.isArray(e.brands)?e.brands.map((function(e){return e.brand+"/"+e.version})).join(" "):navigator.userAgent}function u(){return!/^((?!chrome|android).)*safari/i.test(d())}function p(e,t,n){void 0===t&&(t=!1),void 0===n&&(n=!1);var s=e.getBoundingClientRect(),a=1,l=1;t&&r(e)&&(a=e.offsetWidth>0&&c(s.width)/e.offsetWidth||1,l=e.offsetHeight>0&&c(s.height)/e.offsetHeight||1);var d=(i(e)?o(e):window).visualViewport,p=!u()&&n,h=(s.left+(p&&d?d.offsetLeft:0))/a,f=(s.top+(p&&d?d.offsetTop:0))/l,m=s.width/a,g=s.height/l;return{width:m,height:g,top:f,right:h+m,bottom:f+g,left:h,x:h,y:f}}function h(e){var t=o(e);return{scrollLeft:t.pageXOffset,scrollTop:t.pageYOffset}}function f(e){return e?(e.nodeName||"").toLowerCase():null}function m(e){return((i(e)?e.ownerDocument:e.document)||window.document).documentElement}function g(e){return p(m(e)).left+h(e).scrollLeft}function v(e){return o(e).getComputedStyle(e)}function _(e){var t=v(e),n=t.overflow,o=t.overflowX,i=t.overflowY;return/auto|scroll|overlay|hidden/.test(n+i+o)}function y(e,t,n){void 0===n&&(n=!1);var i,s,a=r(t),l=r(t)&&function(e){var t=e.getBoundingClientRect(),n=c(t.width)/e.offsetWidth||1,o=c(t.height)/e.offsetHeight||1;return 1!==n||1!==o}(t),d=m(t),u=p(e,l,n),v={scrollLeft:0,scrollTop:0},y={x:0,y:0};return(a||!a&&!n)&&(("body"!==f(t)||_(d))&&(v=(i=t)!==o(i)&&r(i)?{scrollLeft:(s=i).scrollLeft,scrollTop:s.scrollTop}:h(i)),r(t)?((y=p(t,!0)).x+=t.clientLeft,y.y+=t.clientTop):d&&(y.x=g(d))),{x:u.left+v.scrollLeft-y.x,y:u.top+v.scrollTop-y.y,width:u.width,height:u.height}}function b(e){var t=p(e),n=e.offsetWidth,o=e.offsetHeight;return Math.abs(t.width-n)<=1&&(n=t.width),Math.abs(t.height-o)<=1&&(o=t.height),{x:e.offsetLeft,y:e.offsetTop,width:n,height:o}}function w(e){return"html"===f(e)?e:e.assignedSlot||e.parentNode||(s(e)?e.host:null)||m(e)}function x(e){return["html","body","#document"].indexOf(f(e))>=0?e.ownerDocument.body:r(e)&&_(e)?e:x(w(e))}function A(e,t){var n;void 0===t&&(t=[]);var i=x(e),r=i===(null==(n=e.ownerDocument)?void 0:n.body),s=o(i),a=r?[s].concat(s.visualViewport||[],_(i)?i:[]):i,l=t.concat(a);return r?l:l.concat(A(w(a)))}function C(e){return["table","td","th"].indexOf(f(e))>=0}function $(e){return r(e)&&"fixed"!==v(e).position?e.offsetParent:null}function O(e){for(var t=o(e),n=$(e);n&&C(n)&&"static"===v(n).position;)n=$(n);return n&&("html"===f(n)||"body"===f(n)&&"static"===v(n).position)?t:n||function(e){var t=/firefox/i.test(d());if(/Trident/i.test(d())&&r(e)&&"fixed"===v(e).position)return null;var n=w(e);for(s(n)&&(n=n.host);r(n)&&["html","body"].indexOf(f(n))<0;){var o=v(n);if("none"!==o.transform||"none"!==o.perspective||"paint"===o.contain||-1!==["transform","perspective"].indexOf(o.willChange)||t&&"filter"===o.willChange||t&&o.filter&&"none"!==o.filter)return n;n=n.parentNode}return null}(e)||t}var S="top",E="bottom",k="right",D="left",L="auto",P=[S,E,k,D],T="start",j="end",q="viewport",R="popper",M=P.reduce((function(e,t){return e.concat([t+"-"+T,t+"-"+j])}),[]),I=[].concat(P,[L]).reduce((function(e,t){return e.concat([t,t+"-"+T,t+"-"+j])}),[]),H=["beforeRead","read","afterRead","beforeMain","main","afterMain","beforeWrite","write","afterWrite"];function z(e){var t=new Map,n=new Set,o=[];function i(e){n.add(e.name),[].concat(e.requires||[],e.requiresIfExists||[]).forEach((function(e){if(!n.has(e)){var o=t.get(e);o&&i(o)}})),o.push(e)}return e.forEach((function(e){t.set(e.name,e)})),e.forEach((function(e){n.has(e.name)||i(e)})),o}var U={placement:"bottom",modifiers:[],strategy:"absolute"};function B(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return!t.some((function(e){return!(e&&"function"==typeof e.getBoundingClientRect)}))}function N(e){void 0===e&&(e={});var t=e,n=t.defaultModifiers,o=void 0===n?[]:n,r=t.defaultOptions,s=void 0===r?U:r;return function(e,t,n){void 0===n&&(n=s);var r,a,l={placement:"bottom",orderedModifiers:[],options:Object.assign({},U,s),modifiersData:{},elements:{reference:e,popper:t},attributes:{},styles:{}},c=[],d=!1,u={state:l,setOptions:function(n){var r="function"==typeof n?n(l.options):n;p(),l.options=Object.assign({},s,l.options,r),l.scrollParents={reference:i(e)?A(e):e.contextElement?A(e.contextElement):[],popper:A(t)};var a,d,h=function(e){var t=z(e);return H.reduce((function(e,n){return e.concat(t.filter((function(e){return e.phase===n})))}),[])}((a=[].concat(o,l.options.modifiers),d=a.reduce((function(e,t){var n=e[t.name];return e[t.name]=n?Object.assign({},n,t,{options:Object.assign({},n.options,t.options),data:Object.assign({},n.data,t.data)}):t,e}),{}),Object.keys(d).map((function(e){return d[e]}))));return l.orderedModifiers=h.filter((function(e){return e.enabled})),l.orderedModifiers.forEach((function(e){var t=e.name,n=e.options,o=void 0===n?{}:n,i=e.effect;if("function"==typeof i){var r=i({state:l,name:t,instance:u,options:o}),s=function(){};c.push(r||s)}})),u.update()},forceUpdate:function(){if(!d){var e=l.elements,t=e.reference,n=e.popper;if(B(t,n)){l.rects={reference:y(t,O(n),"fixed"===l.options.strategy),popper:b(n)},l.reset=!1,l.placement=l.options.placement,l.orderedModifiers.forEach((function(e){return l.modifiersData[e.name]=Object.assign({},e.data)}));for(var o=0;o<l.orderedModifiers.length;o++)if(!0!==l.reset){var i=l.orderedModifiers[o],r=i.fn,s=i.options,a=void 0===s?{}:s,c=i.name;"function"==typeof r&&(l=r({state:l,options:a,name:c,instance:u})||l)}else l.reset=!1,o=-1}}},update:(r=function(){return new Promise((function(e){u.forceUpdate(),e(l)}))},function(){return a||(a=new Promise((function(e){Promise.resolve().then((function(){a=void 0,e(r())}))}))),a}),destroy:function(){p(),d=!0}};if(!B(e,t))return u;function p(){c.forEach((function(e){return e()})),c=[]}return u.setOptions(n).then((function(e){!d&&n.onFirstUpdate&&n.onFirstUpdate(e)})),u}}var W={passive:!0};function G(e){return e.split("-")[0]}function F(e){return e.split("-")[1]}function Y(e){return["top","bottom"].indexOf(e)>=0?"x":"y"}function K(e){var t,n=e.reference,o=e.element,i=e.placement,r=i?G(i):null,s=i?F(i):null,a=n.x+n.width/2-o.width/2,l=n.y+n.height/2-o.height/2;switch(r){case S:t={x:a,y:n.y-o.height};break;case E:t={x:a,y:n.y+n.height};break;case k:t={x:n.x+n.width,y:l};break;case D:t={x:n.x-o.width,y:l};break;default:t={x:n.x,y:n.y}}var c=r?Y(r):null;if(null!=c){var d="y"===c?"height":"width";switch(s){case T:t[c]=t[c]-(n[d]/2-o[d]/2);break;case j:t[c]=t[c]+(n[d]/2-o[d]/2)}}return t}var V={top:"auto",right:"auto",bottom:"auto",left:"auto"};function Z(e){var t,n=e.popper,i=e.popperRect,r=e.placement,s=e.variation,a=e.offsets,l=e.position,d=e.gpuAcceleration,u=e.adaptive,p=e.roundOffsets,h=e.isFixed,f=a.x,g=void 0===f?0:f,_=a.y,y=void 0===_?0:_,b="function"==typeof p?p({x:g,y}):{x:g,y};g=b.x,y=b.y;var w=a.hasOwnProperty("x"),x=a.hasOwnProperty("y"),A=D,C=S,$=window;if(u){var L=O(n),P="clientHeight",T="clientWidth";if(L===o(n)&&"static"!==v(L=m(n)).position&&"absolute"===l&&(P="scrollHeight",T="scrollWidth"),r===S||(r===D||r===k)&&s===j)C=E,y-=(h&&L===$&&$.visualViewport?$.visualViewport.height:L[P])-i.height,y*=d?1:-1;if(r===D||(r===S||r===E)&&s===j)A=k,g-=(h&&L===$&&$.visualViewport?$.visualViewport.width:L[T])-i.width,g*=d?1:-1}var q,R=Object.assign({position:l},u&&V),M=!0===p?function(e,t){var n=e.x,o=e.y,i=t.devicePixelRatio||1;return{x:c(n*i)/i||0,y:c(o*i)/i||0}}({x:g,y},o(n)):{x:g,y};return g=M.x,y=M.y,d?Object.assign({},R,((q={})[C]=x?"0":"",q[A]=w?"0":"",q.transform=($.devicePixelRatio||1)<=1?"translate("+g+"px, "+y+"px)":"translate3d("+g+"px, "+y+"px, 0)",q)):Object.assign({},R,((t={})[C]=x?y+"px":"",t[A]=w?g+"px":"",t.transform="",t))}const J={name:"offset",enabled:!0,phase:"main",requires:["popperOffsets"],fn:function(e){var t=e.state,n=e.options,o=e.name,i=n.offset,r=void 0===i?[0,0]:i,s=I.reduce((function(e,n){return e[n]=function(e,t,n){var o=G(e),i=[D,S].indexOf(o)>=0?-1:1,r="function"==typeof n?n(Object.assign({},t,{placement:e})):n,s=r[0],a=r[1];return s=s||0,a=(a||0)*i,[D,k].indexOf(o)>=0?{x:a,y:s}:{x:s,y:a}}(n,t.rects,r),e}),{}),a=s[t.placement],l=a.x,c=a.y;null!=t.modifiersData.popperOffsets&&(t.modifiersData.popperOffsets.x+=l,t.modifiersData.popperOffsets.y+=c),t.modifiersData[o]=s}};var Q={left:"right",right:"left",bottom:"top",top:"bottom"};function X(e){return e.replace(/left|right|bottom|top/g,(function(e){return Q[e]}))}var ee={start:"end",end:"start"};function te(e){return e.replace(/start|end/g,(function(e){return ee[e]}))}function ne(e,t){var n=t.getRootNode&&t.getRootNode();if(e.contains(t))return!0;if(n&&s(n)){var o=t;do{if(o&&e.isSameNode(o))return!0;o=o.parentNode||o.host}while(o)}return!1}function oe(e){return Object.assign({},e,{left:e.x,top:e.y,right:e.x+e.width,bottom:e.y+e.height})}function ie(e,t,n){return t===q?oe(function(e,t){var n=o(e),i=m(e),r=n.visualViewport,s=i.clientWidth,a=i.clientHeight,l=0,c=0;if(r){s=r.width,a=r.height;var d=u();(d||!d&&"fixed"===t)&&(l=r.offsetLeft,c=r.offsetTop)}return{width:s,height:a,x:l+g(e),y:c}}(e,n)):i(t)?function(e,t){var n=p(e,!1,"fixed"===t);return n.top=n.top+e.clientTop,n.left=n.left+e.clientLeft,n.bottom=n.top+e.clientHeight,n.right=n.left+e.clientWidth,n.width=e.clientWidth,n.height=e.clientHeight,n.x=n.left,n.y=n.top,n}(t,n):oe(function(e){var t,n=m(e),o=h(e),i=null==(t=e.ownerDocument)?void 0:t.body,r=a(n.scrollWidth,n.clientWidth,i?i.scrollWidth:0,i?i.clientWidth:0),s=a(n.scrollHeight,n.clientHeight,i?i.scrollHeight:0,i?i.clientHeight:0),l=-o.scrollLeft+g(e),c=-o.scrollTop;return"rtl"===v(i||n).direction&&(l+=a(n.clientWidth,i?i.clientWidth:0)-r),{width:r,height:s,x:l,y:c}}(m(e)))}function re(e,t,n,o){var s="clippingParents"===t?function(e){var t=A(w(e)),n=["absolute","fixed"].indexOf(v(e).position)>=0&&r(e)?O(e):e;return i(n)?t.filter((function(e){return i(e)&&ne(e,n)&&"body"!==f(e)})):[]}(e):[].concat(t),c=[].concat(s,[n]),d=c[0],u=c.reduce((function(t,n){var i=ie(e,n,o);return t.top=a(i.top,t.top),t.right=l(i.right,t.right),t.bottom=l(i.bottom,t.bottom),t.left=a(i.left,t.left),t}),ie(e,d,o));return u.width=u.right-u.left,u.height=u.bottom-u.top,u.x=u.left,u.y=u.top,u}function se(e){return Object.assign({},{top:0,right:0,bottom:0,left:0},e)}function ae(e,t){return t.reduce((function(t,n){return t[n]=e,t}),{})}function le(e,t){void 0===t&&(t={});var n=t,o=n.placement,r=void 0===o?e.placement:o,s=n.strategy,a=void 0===s?e.strategy:s,l=n.boundary,c=void 0===l?"clippingParents":l,d=n.rootBoundary,u=void 0===d?q:d,h=n.elementContext,f=void 0===h?R:h,g=n.altBoundary,v=void 0!==g&&g,_=n.padding,y=void 0===_?0:_,b=se("number"!=typeof y?y:ae(y,P)),w=f===R?"reference":R,x=e.rects.popper,A=e.elements[v?w:f],C=re(i(A)?A:A.contextElement||m(e.elements.popper),c,u,a),$=p(e.elements.reference),O=K({reference:$,element:x,strategy:"absolute",placement:r}),D=oe(Object.assign({},x,O)),L=f===R?D:$,T={top:C.top-L.top+b.top,bottom:L.bottom-C.bottom+b.bottom,left:C.left-L.left+b.left,right:L.right-C.right+b.right},j=e.modifiersData.offset;if(f===R&&j){var M=j[r];Object.keys(T).forEach((function(e){var t=[k,E].indexOf(e)>=0?1:-1,n=[S,E].indexOf(e)>=0?"y":"x";T[e]+=M[n]*t}))}return T}function ce(e,t,n){return a(e,l(t,n))}const de={name:"preventOverflow",enabled:!0,phase:"main",fn:function(e){var t=e.state,n=e.options,o=e.name,i=n.mainAxis,r=void 0===i||i,s=n.altAxis,c=void 0!==s&&s,d=n.boundary,u=n.rootBoundary,p=n.altBoundary,h=n.padding,f=n.tether,m=void 0===f||f,g=n.tetherOffset,v=void 0===g?0:g,_=le(t,{boundary:d,rootBoundary:u,padding:h,altBoundary:p}),y=G(t.placement),w=F(t.placement),x=!w,A=Y(y),C="x"===A?"y":"x",$=t.modifiersData.popperOffsets,L=t.rects.reference,P=t.rects.popper,j="function"==typeof v?v(Object.assign({},t.rects,{placement:t.placement})):v,q="number"==typeof j?{mainAxis:j,altAxis:j}:Object.assign({mainAxis:0,altAxis:0},j),R=t.modifiersData.offset?t.modifiersData.offset[t.placement]:null,M={x:0,y:0};if($){if(r){var I,H="y"===A?S:D,z="y"===A?E:k,U="y"===A?"height":"width",B=$[A],N=B+_[H],W=B-_[z],K=m?-P[U]/2:0,V=w===T?L[U]:P[U],Z=w===T?-P[U]:-L[U],J=t.elements.arrow,Q=m&&J?b(J):{width:0,height:0},X=t.modifiersData["arrow#persistent"]?t.modifiersData["arrow#persistent"].padding:{top:0,right:0,bottom:0,left:0},ee=X[H],te=X[z],ne=ce(0,L[U],Q[U]),oe=x?L[U]/2-K-ne-ee-q.mainAxis:V-ne-ee-q.mainAxis,ie=x?-L[U]/2+K+ne+te+q.mainAxis:Z+ne+te+q.mainAxis,re=t.elements.arrow&&O(t.elements.arrow),se=re?"y"===A?re.clientTop||0:re.clientLeft||0:0,ae=null!=(I=null==R?void 0:R[A])?I:0,de=B+ie-ae,ue=ce(m?l(N,B+oe-ae-se):N,B,m?a(W,de):W);$[A]=ue,M[A]=ue-B}if(c){var pe,he="x"===A?S:D,fe="x"===A?E:k,me=$[C],ge="y"===C?"height":"width",ve=me+_[he],_e=me-_[fe],ye=-1!==[S,D].indexOf(y),be=null!=(pe=null==R?void 0:R[C])?pe:0,we=ye?ve:me-L[ge]-P[ge]-be+q.altAxis,xe=ye?me+L[ge]+P[ge]-be-q.altAxis:_e,Ae=m&&ye?function(e,t,n){var o=ce(e,t,n);return o>n?n:o}(we,me,xe):ce(m?we:ve,me,m?xe:_e);$[C]=Ae,M[C]=Ae-me}t.modifiersData[o]=M}},requiresIfExists:["offset"]};const ue={name:"arrow",enabled:!0,phase:"main",fn:function(e){var t,n=e.state,o=e.name,i=e.options,r=n.elements.arrow,s=n.modifiersData.popperOffsets,a=G(n.placement),l=Y(a),c=[D,k].indexOf(a)>=0?"height":"width";if(r&&s){var d=function(e,t){return se("number"!=typeof(e="function"==typeof e?e(Object.assign({},t.rects,{placement:t.placement})):e)?e:ae(e,P))}(i.padding,n),u=b(r),p="y"===l?S:D,h="y"===l?E:k,f=n.rects.reference[c]+n.rects.reference[l]-s[l]-n.rects.popper[c],m=s[l]-n.rects.reference[l],g=O(r),v=g?"y"===l?g.clientHeight||0:g.clientWidth||0:0,_=f/2-m/2,y=d[p],w=v-u[c]-d[h],x=v/2-u[c]/2+_,A=ce(y,x,w),C=l;n.modifiersData[o]=((t={})[C]=A,t.centerOffset=A-x,t)}},effect:function(e){var t=e.state,n=e.options.element,o=void 0===n?"[data-popper-arrow]":n;null!=o&&("string"!=typeof o||(o=t.elements.popper.querySelector(o)))&&ne(t.elements.popper,o)&&(t.elements.arrow=o)},requires:["popperOffsets"],requiresIfExists:["preventOverflow"]};function pe(e,t,n){return void 0===n&&(n={x:0,y:0}),{top:e.top-t.height-n.y,right:e.right-t.width+n.x,bottom:e.bottom-t.height+n.y,left:e.left-t.width-n.x}}function he(e){return[S,k,E,D].some((function(t){return e[t]>=0}))}var fe=N({defaultModifiers:[{name:"eventListeners",enabled:!0,phase:"write",fn:function(){},effect:function(e){var t=e.state,n=e.instance,i=e.options,r=i.scroll,s=void 0===r||r,a=i.resize,l=void 0===a||a,c=o(t.elements.popper),d=[].concat(t.scrollParents.reference,t.scrollParents.popper);return s&&d.forEach((function(e){e.addEventListener("scroll",n.update,W)})),l&&c.addEventListener("resize",n.update,W),function(){s&&d.forEach((function(e){e.removeEventListener("scroll",n.update,W)})),l&&c.removeEventListener("resize",n.update,W)}},data:{}},{name:"popperOffsets",enabled:!0,phase:"read",fn:function(e){var t=e.state,n=e.name;t.modifiersData[n]=K({reference:t.rects.reference,element:t.rects.popper,strategy:"absolute",placement:t.placement})},data:{}},{name:"computeStyles",enabled:!0,phase:"beforeWrite",fn:function(e){var t=e.state,n=e.options,o=n.gpuAcceleration,i=void 0===o||o,r=n.adaptive,s=void 0===r||r,a=n.roundOffsets,l=void 0===a||a,c={placement:G(t.placement),variation:F(t.placement),popper:t.elements.popper,popperRect:t.rects.popper,gpuAcceleration:i,isFixed:"fixed"===t.options.strategy};null!=t.modifiersData.popperOffsets&&(t.styles.popper=Object.assign({},t.styles.popper,Z(Object.assign({},c,{offsets:t.modifiersData.popperOffsets,position:t.options.strategy,adaptive:s,roundOffsets:l})))),null!=t.modifiersData.arrow&&(t.styles.arrow=Object.assign({},t.styles.arrow,Z(Object.assign({},c,{offsets:t.modifiersData.arrow,position:"absolute",adaptive:!1,roundOffsets:l})))),t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-placement":t.placement})},data:{}},{name:"applyStyles",enabled:!0,phase:"write",fn:function(e){var t=e.state;Object.keys(t.elements).forEach((function(e){var n=t.styles[e]||{},o=t.attributes[e]||{},i=t.elements[e];r(i)&&f(i)&&(Object.assign(i.style,n),Object.keys(o).forEach((function(e){var t=o[e];!1===t?i.removeAttribute(e):i.setAttribute(e,!0===t?"":t)})))}))},effect:function(e){var t=e.state,n={popper:{position:t.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};return Object.assign(t.elements.popper.style,n.popper),t.styles=n,t.elements.arrow&&Object.assign(t.elements.arrow.style,n.arrow),function(){Object.keys(t.elements).forEach((function(e){var o=t.elements[e],i=t.attributes[e]||{},s=Object.keys(t.styles.hasOwnProperty(e)?t.styles[e]:n[e]).reduce((function(e,t){return e[t]="",e}),{});r(o)&&f(o)&&(Object.assign(o.style,s),Object.keys(i).forEach((function(e){o.removeAttribute(e)})))}))}},requires:["computeStyles"]},J,{name:"flip",enabled:!0,phase:"main",fn:function(e){var t=e.state,n=e.options,o=e.name;if(!t.modifiersData[o]._skip){for(var i=n.mainAxis,r=void 0===i||i,s=n.altAxis,a=void 0===s||s,l=n.fallbackPlacements,c=n.padding,d=n.boundary,u=n.rootBoundary,p=n.altBoundary,h=n.flipVariations,f=void 0===h||h,m=n.allowedAutoPlacements,g=t.options.placement,v=G(g),_=l||(v===g||!f?[X(g)]:function(e){if(G(e)===L)return[];var t=X(e);return[te(e),t,te(t)]}(g)),y=[g].concat(_).reduce((function(e,n){return e.concat(G(n)===L?function(e,t){void 0===t&&(t={});var n=t,o=n.placement,i=n.boundary,r=n.rootBoundary,s=n.padding,a=n.flipVariations,l=n.allowedAutoPlacements,c=void 0===l?I:l,d=F(o),u=d?a?M:M.filter((function(e){return F(e)===d})):P,p=u.filter((function(e){return c.indexOf(e)>=0}));0===p.length&&(p=u);var h=p.reduce((function(t,n){return t[n]=le(e,{placement:n,boundary:i,rootBoundary:r,padding:s})[G(n)],t}),{});return Object.keys(h).sort((function(e,t){return h[e]-h[t]}))}(t,{placement:n,boundary:d,rootBoundary:u,padding:c,flipVariations:f,allowedAutoPlacements:m}):n)}),[]),b=t.rects.reference,w=t.rects.popper,x=new Map,A=!0,C=y[0],$=0;$<y.length;$++){var O=y[$],j=G(O),q=F(O)===T,R=[S,E].indexOf(j)>=0,H=R?"width":"height",z=le(t,{placement:O,boundary:d,rootBoundary:u,altBoundary:p,padding:c}),U=R?q?k:D:q?E:S;b[H]>w[H]&&(U=X(U));var B=X(U),N=[];if(r&&N.push(z[j]<=0),a&&N.push(z[U]<=0,z[B]<=0),N.every((function(e){return e}))){C=O,A=!1;break}x.set(O,N)}if(A)for(var W=function(e){var t=y.find((function(t){var n=x.get(t);if(n)return n.slice(0,e).every((function(e){return e}))}));if(t)return C=t,"break"},Y=f?3:1;Y>0;Y--){if("break"===W(Y))break}t.placement!==C&&(t.modifiersData[o]._skip=!0,t.placement=C,t.reset=!0)}},requiresIfExists:["offset"],data:{_skip:!1}},de,ue,{name:"hide",enabled:!0,phase:"main",requiresIfExists:["preventOverflow"],fn:function(e){var t=e.state,n=e.name,o=t.rects.reference,i=t.rects.popper,r=t.modifiersData.preventOverflow,s=le(t,{elementContext:"reference"}),a=le(t,{altBoundary:!0}),l=pe(s,o),c=pe(a,i,r),d=he(l),u=he(c);t.modifiersData[n]={referenceClippingOffsets:l,popperEscapeOffsets:c,isReferenceHidden:d,hasPopperEscaped:u},t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-reference-hidden":d,"data-popper-escaped":u})}}]}),me=n(113);function ge(e,t){var n=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);t&&(o=o.filter((function(t){return Object.getOwnPropertyDescriptor(e,t).enumerable}))),n.push.apply(n,o)}return n}function ve(e){for(var t=1;t<arguments.length;t++){var n=null!=arguments[t]?arguments[t]:{};t%2?ge(Object(n),!0).forEach((function(t){_e(e,t,n[t])})):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(n)):ge(Object(n)).forEach((function(t){Object.defineProperty(e,t,Object.getOwnPropertyDescriptor(n,t))}))}return e}function _e(e,t,n){return(t=function(e){var t=function(e,t){if("object"!=typeof e||!e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var o=n.call(e,t||"default");if("object"!=typeof o)return o;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(e,"string");return"symbol"==typeof t?t:t+""}(t))in e?Object.defineProperty(e,t,{value:n,enumerable:!0,configurable:!0,writable:!0}):e[t]=n,e}class ye{static register(){let e=document.querySelectorAll(".cs-tooltip, [data-tooltip-target], [data-tooltip]");e.length&&e.forEach((e=>{new ye(e)}))}constructor(e,t={}){_e(this,"uuid",void 0),_e(this,"forElement",void 0),_e(this,"popperInstance",void 0),_e(this,"element",void 0),_e(this,"options",void 0),this.uuid=(0,me.G)(),this.forElement=this.updateTooltipTargetElement(e),this.options=Object.assign({theme:"dark",html:!0,container:"body",mainClass:"shapla-tooltip",activeClass:"is-active",removeOnClose:!0},t),this.popperInstance=null,this.init()}init(){["mouseenter","focus"].forEach((e=>{this.forElement.addEventListener(e,(()=>this.show()))})),["mouseleave","blur"].forEach((e=>{this.forElement.addEventListener(e,(()=>this.hide()))}))}show(){this.createTooltipElementIfNotExists(),this.element?.classList.add(this.options.activeClass),this.popperInstance=fe(this.forElement,this.element,{modifiers:[{name:"offset",options:{offset:[0,8]}}]}),this.popperInstance.setOptions((e=>ve(ve({},e),{},{modifiers:[...e.modifiers,{name:"eventListeners",enabled:!0}]}))),this.popperInstance.update()}hide(){this.element?.classList.remove(this.options.activeClass),this.popperInstance&&this.popperInstance.setOptions((e=>ve(ve({},e),{},{modifiers:[...e.modifiers,{name:"eventListeners",enabled:!1}]}))),this.options.removeOnClose&&setTimeout((()=>this.element?.remove()),10)}createTooltipElementIfNotExists(){if(this.element=document.querySelector(`[data-tooltip-for="${this.uuid}"]`),!this.element){let e=this.forElement.getAttribute("data-tooltip")||this.forElement.getAttribute("title");this.element=this.createTooltipElement(e)}}createTooltipElement(e){let t=(0,me.a)("div",{"data-popper-arrow":"",class:this.options.mainClass+"__arrow"}),n=(0,me.a)("div",{class:this.options.mainClass+"__inner"});this.options.html?n.innerHTML=e:n.innerText=e;let o=(0,me.a)("div",{"data-tooltip-for":this.uuid,"data-remove-on-close":"",role:"tooltip",class:`${this.options.mainClass} is-theme-${this.options.theme}`},[t,n]);return document.querySelector(this.options.container).appendChild(o),o}updateTooltipTargetElement(e){let t=e.getAttribute("data-tooltip")||e.getAttribute("title");return e.setAttribute("aria-describedby","tooltip"),e.setAttribute("data-tooltip-target",this.uuid),e.setAttribute("data-tooltip",t),e.hasAttribute("title")&&e.removeAttribute("title"),e}}const be=ye;n(271),n(776);let we,xe,Ae,Ce,$e,Oe,Se=t()("body"),Ee=t()("#contentButtonModal");const ke=window.CarouselSliderL10n.nonce??"",De=window.CarouselSliderL10n.l10n;Se.on("click",".carousel-slider__add-slide",(function(e){e.preventDefault(),t().ajax({url:ajaxurl,method:"POST",data:{action:"add_content_slide",task:"add-slide",nonce:ke,post_id:t()(this).data("post-id")},success:function(){window.location.reload(!0)}})})),Se.on("click",".carousel_slider__delete_slide",(function(e){e.preventDefault(),confirm(De.confirmDelete)&&t().ajax({url:ajaxurl,method:"POST",data:{action:"add_content_slide",task:"delete-slide",nonce:ke,post_id:t()(this).data("post-id"),slide_pos:t()(this).data("slide-pos")},success:function(){window.location.reload(!0)}})})),Se.on("click",".carousel_slider__move_top",(function(e){e.preventDefault(),t().ajax({url:ajaxurl,method:"POST",data:{action:"add_content_slide",task:"move-slide-top",nonce:ke,post_id:t()(this).data("post-id"),slide_pos:t()(this).data("slide-pos")},success:function(){window.location.reload(!0)}})})),Se.on("click",".carousel_slider__move_up",(function(e){e.preventDefault(),t().ajax({url:ajaxurl,method:"POST",data:{action:"add_content_slide",task:"move-slide-up",nonce:ke,post_id:t()(this).data("post-id"),slide_pos:t()(this).data("slide-pos")},success:function(){window.location.reload(!0)}})})),Se.on("click",".carousel_slider__move_down",(function(e){e.preventDefault(),t().ajax({url:ajaxurl,method:"POST",data:{action:"add_content_slide",task:"move-slide-down",nonce:ke,post_id:t()(this).data("post-id"),slide_pos:t()(this).data("slide-pos")},success:function(){window.location.reload(!0)}})})),Se.on("click",".carousel_slider__move_bottom",(function(e){e.preventDefault(),t().ajax({url:ajaxurl,method:"POST",data:{action:"add_content_slide",task:"move-slide-bottom",nonce:ke,post_id:t()(this).data("post-id"),slide_pos:t()(this).data("slide-pos")},success:function(){window.location.reload(!0)}})})),Se.on("click",".slide_image_add",(function(e){e.preventDefault();var n=t()(this);xe=n.closest(".slide_bg_wrapper"),Ce=xe.find(".content_slide_canvas"),Ae=xe.find(".background_image_id"),$e=xe.find(".delete-bg-img"),we||(we=wp.media({title:n.data("title"),button:{text:n.data("button-text")},multiple:!1}),we.on("select",(function(){var e=we.state().get("selection").first().toJSON();Ce.css("background-image","url("+e.url+")"),Ae.val(e.id),$e.removeClass("hidden")}))),we.open()})),Se.on("click",".delete-bg-img",(function(e){e.preventDefault(),xe=t()(this).closest(".slide_bg_wrapper"),Ce=xe.find(".content_slide_canvas"),Ae=xe.find(".background_image_id"),$e=xe.find(".delete-bg-img"),Ce.css("background-image",""),Ae.val("0"),$e.addClass("hidden")})),Se.on("change",".background_image_position",(function(){var e=t()(this).val();xe=t()(this).closest(".slide_bg_wrapper"),Ce=xe.find(".content_slide_canvas"),Ce.css("background-position",e)})),Se.on("change",".background_image_size",(function(){var e=t()(this).val();xe=t()(this).closest(".slide_bg_wrapper"),Ce=xe.find(".content_slide_canvas"),Ce.css("background-size",e)})),t()(".addContentButton").on("click",(function(e){e.preventDefault(),Oe=t()(this).closest(".button_config");var n=Oe.find(".button_text").val(),o=Oe.find(".button_url").val(),i=Oe.find(".button_target").val(),r=Oe.find(".button_type").val(),s=Oe.find(".button_size").val(),a=Oe.find(".button_color").val();Ee.find("#_button_text").val(n),Ee.find("#_button_url").val(o),Ee.find("#_button_target").val(i),Ee.find("#_button_type").val(r),Ee.find("#_button_size").val(s),Ee.find("#_button_color").val(a),Ee.addClass("is-active")})),t()("#saveContentButton").on("click",(function(e){if(e.preventDefault(),!Oe)return Ee.removeClass("is-active"),!1;var t=Ee.find("#_button_text").val(),n=Ee.find("#_button_url").val(),o=Ee.find("#_button_target").val(),i=Ee.find("#_button_type").val(),r=Ee.find("#_button_size").val(),s=Ee.find("#_button_color").val();Oe.find(".button_text").val(t),Oe.find(".button_url").val(n),Oe.find(".button_target").val(o),Oe.find(".button_type").val(i),Oe.find(".button_size").val(r),Oe.find(".button_color").val(s),Ee.removeClass("is-active")})),t()(".slide-color-picker").each((function(){xe=t()(this).closest(".slide_bg_wrapper"),Ce=xe.find(".content_slide_canvas"),t()(this).wpColorPicker({change:function(e,t){Ce.css("background-color",t.color.toString())}})})),t()(document).on("change",".link_type",(function(e){var n=t()(this),o=n.val(),i=n.closest(".tab-content-link"),r=i.find(".ContentCarouselLinkFull"),s=i.find(".ContentCarouselLinkButtons");"full"===o?(s.hide(),r.show()):"button"===o?(r.hide(),s.show()):(r.hide(),s.hide())}));let Le,Pe=t()("#carousel_slider_gallery_btn"),Te=Me(Pe.data("ids"));const je=(e,n)=>{t()("#_carousel_slider_images_ids").val(e),t()(".carousel_slider_gallery_list").html(n),document.body.dispatchEvent(new CustomEvent("CarouselSlider.refresh.preview"))};Pe.on("click",(function(e){e.preventDefault();let t={title:Pe.data("create"),state:"gallery-edit",frame:"post",selection:Te};(Le||Te)&&(t.title=Pe.data("edit")),Le=wp.media(t).open(),Le.menu.get("view").unset("cancel"),Le.menu.get("view").unset("separateCancel"),Le.menu.get("view").get("gallery-edit").el.innerHTML=Pe.data("edit"),Le.content.get("view").sidebar.unset("gallery"),Re(),Le.on("toolbar:render:gallery-edit",(function(){Re()})),Le.on("content:render:browse",(function(e){e&&(e.sidebar.on("ready",(function(){e.sidebar.unset("gallery")})),e.toolbar.on("ready",(function(){"gallery-library"===e.toolbar.controller._state&&e.toolbar.$el.hide()})))})),Le.state().get("library").on("remove",(function(){0===Le.state().get("library").length&&(Te=!1,je("",""))}))}));const qe=()=>{let e=Le.state().get("library"),t=[],n="";e.each((function(e){t.push(e.id);let o=e.attributes.sizes.thumbnail||e.attributes.sizes.full;n+=`<li><img src="${o.url}" width="50" height="50" class="attachment-50x50 size-50x50" loading="lazy"></li>`})),Te=Me(t.toString()),Le.close(),je(t.toString(),n)};function Re(){Le.toolbar.get("view").set({insert:{style:"primary",text:Pe.data("save"),click:()=>qe()}})}function Me(e){if(!e)return!1;"string"!=typeof e&&(e=e.toString());let t=new wp.shortcode({tag:"gallery",attrs:{ids:e},type:"single"}),n=wp.media.gallery.attachments(t),o=new wp.media.model.Selection(n.models,{props:n.props.toJSON(),multiple:!0});return o.gallery=n.gallery,o.more().done((function(){o.props.set({query:!1}),o.unmirror(),o.props.unset("orderby")})),o}const Ie=window.CarouselSliderAdminL10n,He=document.querySelector("#CarouselSliderModal");let ze=`<div class="media-url--column shapla-column is-12">\n<div class="carousel_slider-fields media-url-form-field">\n\t<div class="media-url-form-field__content">\n\t\t<label class="setting media-url-form-field__item">\n\t\t\t<span class="name">${Ie.url}</span>\n\t\t\t<input type="url" name="_images_urls[url][]" value="" autocomplete="off">\n\t\t</label>\n\t\t<label class="setting media-url-form-field__item">\n\t\t\t<span class="name">${Ie.title}</span>\n\t\t\t<input type="text" name="_images_urls[title][]" value="" autocomplete="off">\n\t\t</label>\n\t\t<label class="setting media-url-form-field__item">\n\t\t\t<span class="name">${Ie.caption}</span>\n\t\t\t<textarea name="_images_urls[caption][]"></textarea>\n\t\t</label>\n\t\t<label class="setting media-url-form-field__item">\n\t\t\t<span class="name">${Ie.altText}</span>\n\t\t\t<input type="text" name="_images_urls[alt][]" value="" autocomplete="off">\n\t\t</label>\n\t\t<label class="setting media-url-form-field__item">\n\t\t\t<span class="name">${Ie.linkToUrl}</span>\n\t\t\t<input type="text" name="_images_urls[link_url][]" value="" autocomplete="off">\n\t\t</label>\n\t</div>\n\t<div class="media-url-form-field__actions">\n\t\t<span class="move_row"><span class="dashicons dashicons-move"></span></span>\n\t\t<span class="add_row"><span class="dashicons dashicons-plus-alt"></span></span>\n\t\t<span class="delete_row"><span class="dashicons dashicons-trash"></span></span>\n\t</div>\n</div>\n</div>`;t()(document).on("click","#_images_urls_btn",(e=>{e.preventDefault(),t()("body").addClass("overflowHidden"),He&&He.setAttribute("open","")})),He&&He.addEventListener("close",(()=>{t()("body").removeClass("overflowHidden"),He.removeAttribute("open")})),t()(document).on("click",".add_row",(function(e){e.preventDefault();let n=t()("#CarouselSliderModal"),o=t()(this).closest(".media-url--column");if(o.length)o.after(ze);else{let e=n.find(".media-url--column");e.length?e.last().after(ze):n.find("#carousel_slider_form").prepend(ze)}})),t()(document).on("click",".delete_row",(function(){confirm("Are you sure to delete?")&&t()(this).closest(".media-url--column").remove()})),t()("#carousel_slider_form").sortable();const Ue=()=>{let e=t()("#_post_query_type").val(),n=t()("#field-_post_date_after"),o=t()("#field-_post_date_before"),i=t()("#field-_post_categories"),r=t()("#field-_post_tags"),s=t()("#field-_post_in"),a=t()("#field-_posts_per_page");n.hide("fast"),o.hide("fast"),i.hide("fast"),r.hide("fast"),s.hide("fast"),a.show("fast"),"date_range"===e&&(n.slideDown(),o.slideDown()),"post_categories"===e&&i.slideDown(),"post_tags"===e&&r.slideDown(),"specific_posts"===e&&(s.slideDown(),a.hide("fast"))};t()("#_post_query_type").on("change",(()=>Ue())),t()(document).ready((()=>Ue()));const Be=()=>{let e=t()("#_product_query_type").val(),n=t()("#field-_product_query"),o=t()("#field-_product_categories"),i=t()("#field-_product_tags"),r=t()("#field-_product_in"),s=t()("#field-_products_per_page");n.hide("fast"),o.hide("fast"),i.hide("fast"),r.hide("fast"),s.show("fast"),"query_product"===e&&n.slideDown(),"product_categories"===e&&o.slideDown(),"product_tags"===e&&i.slideDown(),"specific_products"===e&&(r.slideDown(),s.hide("fast"))};t()("#_product_query_type").on("change",(()=>Be())),t()(document).ready((()=>Be()));const Ne=window.CarouselSliderAdminL10n.videoCarousel,We="carousel_slider-fields--video-urls",Ge=`<div class="carousel_slider-fields--video-urls shapla-column is-12 is-6-fullhd">\n    <div class="carousel_slider-fields media-url-form-field">\n      <div class="media-url-form-field__content">\n          <label class="setting media-url-form-field__item">\n              <span class="name">${Ne.YoutubeOrVimeoURL}</span>\n              <input type="url" name="_video_urls[]" value="" autocomplete="off" \n              placeholder="https://www.youtube.com/watch?v=UOYK79yVrJ4">\n          </label>\n      </div>\n      <div class="media-url-form-field__actions flex-direction-row">\n          <span class="sort_video_url_row"><span class="dashicons dashicons-move"></span></span>\n          <span class="add_video_url_row"><span class="dashicons dashicons-plus-alt"></span></span>\n          <span class="delete_video_url_row"><span class="dashicons dashicons-trash"></span></span>\n      </div>\n    </div>\n</div>`;t()(document).on("click",".add_video_url_row",(function(e){e.preventDefault();let n=t()("#carousel-slider-video-carousel-urls"),o=t()(this).closest(`.${We}`);if(o.length)o.after(Ge);else{let e=n.find(`.${We}`);e.length?e.last().after(Ge):n.prepend(Ge)}})),t()(document).on("click",".delete_video_url_row",(function(){confirm(`${Ne.AreYouSureToDelete}`)&&t()(this).closest(`.${We}`).remove()})),t().fn.sortable&&t()("#carousel-slider-video-carousel-urls").sortable({handle:".sort_video_url_row",placeholder:"cs-sortable-state-highlight shapla-column is-12 is-6-fullhd"});n(294),n(913),n(639);let Fe=document.querySelectorAll(".cs-tooltip");Fe.length&&Fe.forEach((e=>new be(e,{theme:"light"}))),t()(".color-picker").each((function(){t()(this).wpColorPicker()})),t()("select.select2").each((function(){t()(this).select2()})),t()(".shapla-toggle").each((function(){"closed"===t()(this).attr("data-id")?t()(this).accordion({collapsible:!0,heightStyle:"content",active:!1}):t()(this).accordion({collapsible:!0,heightStyle:"content"})})),t()(".shapla-tabs").tabs({hide:{effect:"fadeOut",duration:200},show:{effect:"fadeIn",duration:200}}),document.querySelectorAll(".input-copy-to-clipboard").forEach((e=>{e.addEventListener("click",(()=>{navigator.permissions.query({name:"clipboard-write"}).then((t=>{"granted"===t.state||"prompt"===t.state?navigator.clipboard.writeText(e.innerHTML).then((()=>{window.console.log("Copied successfully")})).catch((e=>{window.console.log("Fail to copy",e)})):window.console.log("ClipBoard API status: "+t.state)}))}))}));const Ye=e=>{let t=document.querySelector("#field-_slides_per_view");t.style.display="slider"===e?"none":"block"},Ke=e=>{let t=document.querySelector("#field-_auto_width");t.style.display="slider"===e?"none":"block"};document.querySelectorAll('[name="carousel_slider[_type_of_slider]"]').forEach((e=>{e.addEventListener("change",(e=>{Ye(e.target.value),Ke(e.target.value)}))})),document.addEventListener("DOMContentLoaded",(()=>{let e=document.querySelector('[name="carousel_slider[_type_of_slider]"]:checked');e&&(Ye(e.value),Ke(e.value));let t=document.querySelector('[type="checkbox"][name="carousel_slider[_auto_width]"]:checked');t&&Ye(t?"slider":"carousel")})),document.querySelectorAll('[type="checkbox"][name="carousel_slider[_auto_width]"]').forEach((e=>{e.addEventListener("change",(e=>{Ye(e.target.checked?"slider":"carousel")}))}))})()})();